/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.repository.hsqldb.Database;

final class ApplicationPropertiesDatabase
extends Database {
    static final ApplicationPropertiesDatabase INSTANCE = new ApplicationPropertiesDatabase();
    private static final Logger LOGGER = Logger.getLogger(ApplicationPropertiesDatabase.class.getName());
    private static final String VALUE_FALSE = "0";
    private static final String VALUE_TRUE = "1";

    private ApplicationPropertiesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean existsKey(String key) {
        boolean bl;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT COUNT(*) FROM application WHERE key = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, key);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            bl = count > 0;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ApplicationPropertiesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ApplicationPropertiesDatabase.close(rs, stmt);
            this.free(con);
            return false;
        }
        ApplicationPropertiesDatabase.close(rs, stmt);
        this.free(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            String sql = "DELETE FROM application WHERE key = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, key);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ApplicationPropertiesDatabase.close(stmt);
                this.free(con);
            }
        }
        ApplicationPropertiesDatabase.close(stmt);
        this.free(con);
    }

    boolean getBoolean(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String value = this.getString(key);
        return value == null ? false : value.equals(VALUE_TRUE);
    }

    void setBoolean(String key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.setString(key, value ? VALUE_TRUE : VALUE_FALSE);
    }

    private String getInsertOrUpdateStmt(String key) {
        if (this.existsKey(key)) {
            return "UPDATE application SET value = ? WHERE key = ?";
        }
        return "INSERT INTO application (value, key) VALUES (?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setString(String key, String string) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement(this.getInsertOrUpdateStmt(key));
            stmt.setBytes(1, string.getBytes());
            stmt.setString(2, key);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ApplicationPropertiesDatabase.close(stmt);
                this.free(con);
            }
        }
        ApplicationPropertiesDatabase.close(stmt);
        this.free(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(String key) {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            con = null;
            stmt = null;
            rs = null;
            string = null;
            try {
                String sql = "SELECT value FROM application WHERE key = ?";
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, key);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                byte[] bytes = rs.getBytes(1);
                string = rs.wasNull() || bytes == null ? null : new String(bytes);
            }
            catch (Throwable t) {
                try {
                    string = null;
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ApplicationPropertiesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ApplicationPropertiesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ApplicationPropertiesDatabase.close(rs, stmt);
        this.free(con);
        return string;
    }
}

