/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.branding.AppProperties;
import org.jphototagger.domain.repository.ApplicationPropertiesRepository;
import org.jphototagger.domain.thumbnails.ThumbnailsDirectoryProvider;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.Version;
import org.jphototagger.repository.hsqldb.ConnectionPool;
import org.jphototagger.repository.hsqldb.DatabaseTables;
import org.jphototagger.repository.hsqldb.update.tables.DatabaseUpdate;
import org.openide.util.Lookup;

public final class AppDatabase {
    private static final String KEY_DATABASE_VERSION = "VersionLastDbUpdate";
    private static boolean init;
    static final Version DATABASE_VERSION;
    private static final Logger LOGGER;

    private AppDatabase() {
    }

    static synchronized void init() {
        assert (!init);
        if (!init) {
            try {
                ConnectionPool.INSTANCE.init();
                AppDatabase.ensureAppIsNotTooOld();
                AppDatabase.ensureThumbnailDirExists();
                DatabaseUpdate databaseUpdate = new DatabaseUpdate();
                databaseUpdate.preCreateTables();
                DatabaseTables.INSTANCE.createTables();
                databaseUpdate.postCreateTables();
                AppDatabase.persistDatabaseVersion();
                init = true;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static void ensureAppIsNotTooOld() {
        Version dbVersion;
        Version appVersion = AppDatabase.getAppVersion();
        if (appVersion.compareTo(dbVersion = AppDatabase.getPersistedDatabaseVersion()) < 0) {
            String message = Bundle.getString(AppDatabase.class, (String)"AppDatabase.Error.NewerDbVersion", (Object[])new Object[]{dbVersion.toString3(), appVersion.toString3()});
            MessageDisplayer.error(null, (String)message);
            throw new RuntimeException("Invalid database version (Database is newer than JPhotoTagger)");
        }
    }

    private static Version getAppVersion() {
        String versionString = ((AppProperties)Lookup.getDefault().lookup(AppProperties.class)).getAppVersionString();
        return Version.parseVersion((String)versionString, (String)".");
    }

    public static Version getPersistedDatabaseVersion() {
        ApplicationPropertiesRepository appPropertiesRepo = (ApplicationPropertiesRepository)Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
        return appPropertiesRepo.existsKey(KEY_DATABASE_VERSION) ? Version.parseVersion((String)appPropertiesRepo.getString(KEY_DATABASE_VERSION), (String)".") : new Version(0, 0, 0);
    }

    private static void persistDatabaseVersion() {
        ApplicationPropertiesRepository appPropertiesRepo = (ApplicationPropertiesRepository)Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
        String versionString = DATABASE_VERSION.toString3();
        appPropertiesRepo.setString(KEY_DATABASE_VERSION, versionString);
    }

    private static void ensureThumbnailDirExists() {
        ThumbnailsDirectoryProvider provider = (ThumbnailsDirectoryProvider)Lookup.getDefault().lookup(ThumbnailsDirectoryProvider.class);
        File directory = provider.getThumbnailsDirectory();
        try {
            FileUtil.ensureDirectoryExists((File)directory);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            String message = Bundle.getString(AppDatabase.class, (String)"AppDatabase.Error.TnDir", (Object[])new Object[]{directory});
            MessageDisplayer.error(null, (String)message);
            throw new RuntimeException("Thumbnail directory could not be created");
        }
    }

    static {
        DATABASE_VERSION = new Version(0, 25, 0);
        LOGGER = Logger.getLogger(AppDatabase.class.getName());
    }
}

