/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.event.repoupdates.ActionAfterRepoUpdateDeletedEvent;
import org.jphototagger.domain.repository.event.repoupdates.ActionAfterRepoUpdateInsertedEvent;
import org.jphototagger.domain.repository.event.repoupdates.ActionsAfterRepoUpdateReorderedEvent;
import org.jphototagger.repository.hsqldb.Database;
import org.openide.util.Lookup;

final class ActionsAfterDbInsertionDatabase
extends Database {
    private static final Logger LOGGER = Logger.getLogger(ActionsAfterDbInsertionDatabase.class.getName());
    static final ActionsAfterDbInsertionDatabase INSTANCE = new ActionsAfterDbInsertionDatabase();
    private final ProgramsRepository programsRepo = (ProgramsRepository)Lookup.getDefault().lookup(ProgramsRepository.class);

    private ActionsAfterDbInsertionDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertAction(Program program, int order) {
        PreparedStatement stmt;
        Connection con;
        int countAffectedRows;
        block5: {
            if (program == null) {
                throw new NullPointerException("action == null");
            }
            countAffectedRows = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("INSERT INTO actions_after_db_insertion (id_program, action_order) VALUES (?, ?)");
                stmt.setLong(1, program.getId());
                stmt.setInt(2, order);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                con.commit();
                if (countAffectedRows <= 0) break block5;
                EventBus.publish((Object)new ActionAfterRepoUpdateInsertedEvent((Object)this, program));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ActionsAfterDbInsertionDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ActionsAfterDbInsertionDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ActionsAfterDbInsertionDatabase.close(stmt);
                this.free(con);
            }
        }
        ActionsAfterDbInsertionDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteAction(Program program) {
        PreparedStatement stmt;
        Connection con;
        int countAffectedRows;
        block5: {
            if (program == null) {
                throw new NullPointerException("action == null");
            }
            countAffectedRows = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM actions_after_db_insertion WHERE id_program = ?");
                stmt.setLong(1, program.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                con.commit();
                if (countAffectedRows <= 0) break block5;
                EventBus.publish((Object)new ActionAfterRepoUpdateDeletedEvent((Object)this, program));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ActionsAfterDbInsertionDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ActionsAfterDbInsertionDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ActionsAfterDbInsertionDatabase.close(stmt);
                this.free(con);
            }
        }
        ActionsAfterDbInsertionDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Program> getAllActions() {
        LinkedList<Program> programs = new LinkedList<Program>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = "SELECT id_program FROM actions_after_db_insertion ORDER BY action_order ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                long idProgram = rs.getLong(1);
                Program program = this.programsRepo.findProgram(idProgram);
                if (program == null) {
                    LOGGER.log(Level.WARNING, "Error getting an action to start after insertion of metadata into the database: The programm whith the ID {0} not exist!", idProgram);
                    continue;
                }
                programs.add(program);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ActionsAfterDbInsertionDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ActionsAfterDbInsertionDatabase.close(rs, stmt);
            this.free(con);
        }
        ActionsAfterDbInsertionDatabase.close(rs, stmt);
        this.free(con);
        return programs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsAction(Program action) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (action == null) {
                throw new NullPointerException("action == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM actions_after_db_insertion WHERE id_program = ?");
                stmt.setLong(1, action.getId());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ActionsAfterDbInsertionDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ActionsAfterDbInsertionDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ActionsAfterDbInsertionDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActionCount() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = 0;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM actions_after_db_insertion";
                stmt = con.createStatement();
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ActionsAfterDbInsertionDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ActionsAfterDbInsertionDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ActionsAfterDbInsertionDatabase.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setActionOrder(List<Program> actions, int startIndex) {
        PreparedStatement stmt;
        boolean allReordered;
        Connection con;
        block6: {
            if (actions == null) {
                throw new NullPointerException("actions == null");
            }
            con = null;
            allReordered = false;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE actions_after_db_insertion SET action_order = ? WHERE id_program = ?");
                int index = startIndex;
                int countAffected = 0;
                for (Program action : actions) {
                    stmt.setInt(1, index++);
                    stmt.setLong(2, action.getId());
                    LOGGER.log(Level.FINER, stmt.toString());
                    countAffected += stmt.executeUpdate();
                }
                con.commit();
                boolean bl = allReordered = countAffected == actions.size();
                if (!allReordered) break block6;
                EventBus.publish((Object)new ActionsAfterRepoUpdateReorderedEvent((Object)this, actions));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ActionsAfterDbInsertionDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ActionsAfterDbInsertionDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ActionsAfterDbInsertionDatabase.close(stmt);
                this.free(con);
            }
        }
        ActionsAfterDbInsertionDatabase.close(stmt);
        this.free(con);
        return allReordered;
    }
}

