/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule.comparators;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.util.ClassEquality;
import org.openide.util.Lookup;

public final class XmpExifDateTimeAscendingComparator
extends ClassEquality
implements Comparator<File>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private static final SimpleDateFormat EXIF_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public int compare(File fileLeft, File fileRight) {
        String timeLeft = this.getTimeString(fileLeft);
        String timeRight = this.getTimeString(fileRight);
        return timeLeft.compareTo(timeRight);
    }

    private String getTimeString(File file) {
        boolean hasExif;
        long exifTimestamp = this.repo.findExifDateTimeOriginalTimestamp(file);
        boolean bl = hasExif = exifTimestamp >= 0L;
        if (hasExif) {
            Date exifDate = new Date(exifTimestamp);
            return EXIF_DATE_FORMAT.format(exifDate);
        }
        String xmpDate = this.repo.findXmpIptc4CoreDateCreated(file);
        return xmpDate != null ? xmpDate : "";
    }

    public String toString() {
        return "XMP and EXIF Dates Ascending";
    }
}

