/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule;

import com.adobe.xmp.properties.XMPPropertyInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jphototagger.lib.swing.TableModelExt;
import org.jphototagger.lib.util.Bundle;

public final class XmpTableModel
extends TableModelExt {
    private static final long serialVersionUID = 1L;
    private File file;
    private List<XMPPropertyInfo> propertyInfos;

    public XmpTableModel() {
        this.setRowHeaders();
    }

    public void setPropertyInfosOfFile(File file, List<XMPPropertyInfo> propertyInfos) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (propertyInfos == null) {
            throw new NullPointerException("propertyInfos == null");
        }
        this.file = file;
        this.propertyInfos = new ArrayList<XMPPropertyInfo>(propertyInfos);
        this.removeAllRows();
        this.addRows();
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private void addRows() {
        if (this.propertyInfos != null) {
            for (XMPPropertyInfo xmpPropertyInfo : this.propertyInfos) {
                this.addRow(xmpPropertyInfo);
            }
        }
    }

    private void addRow(XMPPropertyInfo xmpPropertyInfo) {
        String path = xmpPropertyInfo.getPath();
        Object value = xmpPropertyInfo.getValue();
        if (path != null && value != null && !path.contains("Digest")) {
            ArrayList<XMPPropertyInfo> newRow = new ArrayList<XMPPropertyInfo>();
            newRow.add(xmpPropertyInfo);
            newRow.add(xmpPropertyInfo);
            super.addRow((Object[])newRow.toArray(new XMPPropertyInfo[newRow.size()]));
        }
    }

    private void setRowHeaders() {
        this.addColumn(Bundle.getString(XmpTableModel.class, (String)"XmpTableModel.HeaderColumn.1", (Object[])new Object[0]));
        this.addColumn(Bundle.getString(XmpTableModel.class, (String)"XmpTableModel.HeaderColumn.2", (Object[])new Object[0]));
    }
}

