/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule;

import com.adobe.xmp.properties.XMPPropertyInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jphototagger.api.branding.TableLookAndFeel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.swing.TableTextFilter;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.TableUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.lib.util.Translation;
import org.jphototagger.xmp.EmbeddedXmpCache;
import org.jphototagger.xmp.XmpMetadata;
import org.jphototagger.xmpmodule.XmpTableModel;
import org.openide.util.Lookup;

public class XmpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final XmpTableModel modelXmpCameraRawSettings = new XmpTableModel();
    private final XmpTableModel modelXmpDc = new XmpTableModel();
    private final XmpTableModel modelXmpExif = new XmpTableModel();
    private final XmpTableModel modelXmpIptc = new XmpTableModel();
    private final XmpTableModel modelXmpLightroom = new XmpTableModel();
    private final XmpTableModel modelXmpPhotoshop = new XmpTableModel();
    private final XmpTableModel modelXmpTiff = new XmpTableModel();
    private final XmpTableModel modelXmpXap = new XmpTableModel();
    private final XmpTableCellRenderer xmpTableCellRenderer = new XmpTableCellRenderer();
    private final Map<JTable, XmpTableModel> modelOfTable = new HashMap<JTable, XmpTableModel>();
    private final Map<XmpTableModel, String[]> namespacesOfXmpTableModel = new HashMap<XmpTableModel, String[]>();
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private JLabel labelTableXmpCameraRawSettingsFilter;
    private JLabel labelTableXmpDcFilter;
    private JLabel labelTableXmpExifFilter;
    private JLabel labelTableXmpIptcFilter;
    private JLabel labelTableXmpLightroomFilter;
    private JLabel labelTableXmpPhotoshopFilter;
    private JLabel labelTableXmpTiffFilter;
    private JLabel labelTableXmpXapFilter;
    private JPanel panelTableXmpCameraRawSettings;
    private JPanel panelTableXmpCameraRawSettingsFilter;
    private JPanel panelTableXmpDc;
    private JPanel panelTableXmpDcFilter;
    private JPanel panelTableXmpExif;
    private JPanel panelTableXmpExifFilter;
    private JPanel panelTableXmpIptc;
    private JPanel panelTableXmpIptcFilter;
    private JPanel panelTableXmpLightroom;
    private JPanel panelTableXmpLightroomFilter;
    private JPanel panelTableXmpPhotoshop;
    private JPanel panelTableXmpPhotoshopFilter;
    private JPanel panelTableXmpTiff;
    private JPanel panelTableXmpTiffFilter;
    private JPanel panelTableXmpXap;
    private JPanel panelTableXmpXapFilter;
    private JScrollPane scrollPaneXmpCameraRawSettings;
    private JScrollPane scrollPaneXmpDc;
    private JScrollPane scrollPaneXmpExif;
    private JScrollPane scrollPaneXmpIptc;
    private JScrollPane scrollPaneXmpLightroom;
    private JScrollPane scrollPaneXmpPhotoshop;
    private JScrollPane scrollPaneXmpTiff;
    private JScrollPane scrollPaneXmpXap;
    private JTabbedPane tabbedPaneXmp;
    private JTable tableXmpCameraRawSettings;
    private JTable tableXmpDc;
    private JTable tableXmpExif;
    private JTable tableXmpIptc;
    private JTable tableXmpLightroom;
    private JTable tableXmpPhotoshop;
    private JTable tableXmpTiff;
    private JTable tableXmpXap;
    private JTextField textFieldTableXmpCameraRawSettingsFilter;
    private JTextField textFieldTableXmpDcFilter;
    private JTextField textFieldTableXmpExifFilter;
    private JTextField textFieldTableXmpIptcFilter;
    private JTextField textFieldTableXmpLightroomFilter;
    private JTextField textFieldTableXmpPhotoshopFilter;
    private JTextField textFieldTableXmpTiffFilter;
    private JTextField textFieldTableXmpXapFilter;

    public XmpPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void initTablelsModelsMap() {
        this.modelOfTable.put(this.tableXmpCameraRawSettings, this.modelXmpCameraRawSettings);
        this.modelOfTable.put(this.tableXmpDc, this.modelXmpDc);
        this.modelOfTable.put(this.tableXmpExif, this.modelXmpExif);
        this.modelOfTable.put(this.tableXmpIptc, this.modelXmpIptc);
        this.modelOfTable.put(this.tableXmpLightroom, this.modelXmpLightroom);
        this.modelOfTable.put(this.tableXmpPhotoshop, this.modelXmpPhotoshop);
        this.modelOfTable.put(this.tableXmpTiff, this.modelXmpTiff);
        this.modelOfTable.put(this.tableXmpXap, this.modelXmpXap);
    }

    private void initNamespacesOfXmpTableModelMap() {
        this.namespacesOfXmpTableModel.put(this.modelXmpDc, new String[]{"http://purl.org/dc/elements/1.1/", "http://purl.org/dc/1.1/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpExif, new String[]{"http://ns.adobe.com/exif/1.0/", "http://ns.adobe.com/exif/1.0/aux/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpIptc, new String[]{"http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpLightroom, new String[]{"http://ns.adobe.com/lightroom/1.0/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpPhotoshop, new String[]{"http://ns.adobe.com/photoshop/1.0/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpTiff, new String[]{"http://ns.adobe.com/tiff/1.0/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpCameraRawSettings, new String[]{"http://ns.adobe.com/camera-raw-settings/1.0/", "http://ns.adobe.com/camera-raw-saved-settings/1.0/"});
        this.namespacesOfXmpTableModel.put(this.modelXmpXap, new String[]{"http://ns.adobe.com/xap/1.0/", "http://ns.adobe.com/xap/1.0/rights/"});
    }

    private void postInitComponents() {
        this.initTablelsModelsMap();
        this.initNamespacesOfXmpTableModelMap();
        this.setModels();
        this.setRenderer();
        this.setTableTextFilters();
        this.setTableComparators();
    }

    private void setModels() {
        for (JTable table : this.modelOfTable.keySet()) {
            table.setModel((TableModel)((Object)this.modelOfTable.get(table)));
        }
    }

    private void setRenderer() {
        for (JTable table : this.modelOfTable.keySet()) {
            table.setDefaultRenderer(Object.class, this.xmpTableCellRenderer);
        }
    }

    private void setTableTextFilters() {
        this.setTableTextFilter(this.textFieldTableXmpCameraRawSettingsFilter, this.tableXmpCameraRawSettings);
        this.setTableTextFilter(this.textFieldTableXmpDcFilter, this.tableXmpDc);
        this.setTableTextFilter(this.textFieldTableXmpExifFilter, this.tableXmpExif);
        this.setTableTextFilter(this.textFieldTableXmpIptcFilter, this.tableXmpIptc);
        this.setTableTextFilter(this.textFieldTableXmpLightroomFilter, this.tableXmpLightroom);
        this.setTableTextFilter(this.textFieldTableXmpPhotoshopFilter, this.tableXmpPhotoshop);
        this.setTableTextFilter(this.textFieldTableXmpTiffFilter, this.tableXmpTiff);
        this.setTableTextFilter(this.textFieldTableXmpXapFilter, this.tableXmpXap);
    }

    private void setTableTextFilter(JTextComponent filterTextComponent, JTable xmpTable) {
        TableRowSorter rowSorter = (TableRowSorter)xmpTable.getRowSorter();
        TableStringConverter stringConverter = XmpTableCellRenderer.createTableStringConverter();
        Document document = filterTextComponent.getDocument();
        TableTextFilter tableTextFilter = new TableTextFilter(xmpTable, stringConverter);
        rowSorter.setStringConverter(stringConverter);
        document.addDocumentListener((DocumentListener)tableTextFilter);
    }

    private void setTableComparators() {
        for (JTable table : this.modelOfTable.keySet()) {
            this.setTableComparator(table);
        }
    }

    private void setTableComparator(JTable xmpTable) {
        TableRowSorter rowSorter = (TableRowSorter)xmpTable.getRowSorter();
        Comparator<?> column0Comparator = XmpTableCellRenderer.createColumn0Comparator();
        Comparator<?> column1Comparator = XmpTableCellRenderer.createColumn1Comparator();
        rowSorter.setComparator(0, column0Comparator);
        rowSorter.setComparator(1, column1Comparator);
    }

    void removeAllRows() {
        for (XmpTableModel xmpTableModel : this.modelOfTable.values()) {
            xmpTableModel.removeAllRows();
        }
    }

    private void resizeTables() {
        for (JTable table : this.modelOfTable.keySet()) {
            TableUtil.resizeColumnWidthsToFit((JTable)table);
            ComponentUtil.forceRepaint((Component)table);
        }
    }

    void setFile(File file) {
        this.setXmpModels(file);
        this.resizeTables();
    }

    private void setXmpModels(File file) {
        List allInfos = null;
        File sidecarFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(file);
        try {
            allInfos = sidecarFile != null ? XmpMetadata.getPropertyInfosOfSidecarFile((File)sidecarFile) : (this.isScanForEmbeddedXmp() ? EmbeddedXmpCache.INSTANCE.getXmpPropertyInfos(file) : null);
        }
        catch (Throwable throwable) {
            Logger.getLogger(XmpPanel.class.getName()).log(Level.SEVERE, null, throwable);
        }
        if (allInfos != null) {
            for (XmpTableModel xmpTableModel : this.modelOfTable.values()) {
                this.setPropertyInfosToXmpTableModel(file, xmpTableModel, allInfos, this.namespacesOfXmpTableModel.get((Object)xmpTableModel));
            }
        }
    }

    private boolean isScanForEmbeddedXmp() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ScanForEmbeddedXmp") ? prefs.getBoolean("UserSettings.ScanForEmbeddedXmp") : false;
    }

    private void setPropertyInfosToXmpTableModel(File imageFile, XmpTableModel model, List<XMPPropertyInfo> allInfos, String[] namespaces) {
        ArrayList<XMPPropertyInfo> infos = new ArrayList<XMPPropertyInfo>();
        for (String namespace : namespaces) {
            infos.addAll(XmpMetadata.filterPropertyInfosOfNamespace(allInfos, (String)namespace));
        }
        model.setPropertyInfosOfFile(imageFile, infos);
    }

    private void initComponents() {
        this.tabbedPaneXmp = new JTabbedPane();
        this.panelTableXmpTiff = new JPanel();
        this.panelTableXmpTiffFilter = new JPanel();
        this.labelTableXmpTiffFilter = new JLabel();
        this.textFieldTableXmpTiffFilter = new JTextField();
        this.scrollPaneXmpTiff = new JScrollPane();
        this.tableXmpTiff = new JTable();
        this.panelTableXmpExif = new JPanel();
        this.panelTableXmpExifFilter = new JPanel();
        this.labelTableXmpExifFilter = new JLabel();
        this.textFieldTableXmpExifFilter = new JTextField();
        this.scrollPaneXmpExif = new JScrollPane();
        this.tableXmpExif = new JTable();
        this.panelTableXmpDc = new JPanel();
        this.panelTableXmpDcFilter = new JPanel();
        this.labelTableXmpDcFilter = new JLabel();
        this.textFieldTableXmpDcFilter = new JTextField();
        this.scrollPaneXmpDc = new JScrollPane();
        this.tableXmpDc = new JTable();
        this.panelTableXmpIptc = new JPanel();
        this.panelTableXmpIptcFilter = new JPanel();
        this.labelTableXmpIptcFilter = new JLabel();
        this.textFieldTableXmpIptcFilter = new JTextField();
        this.scrollPaneXmpIptc = new JScrollPane();
        this.tableXmpIptc = new JTable();
        this.panelTableXmpPhotoshop = new JPanel();
        this.panelTableXmpPhotoshopFilter = new JPanel();
        this.labelTableXmpPhotoshopFilter = new JLabel();
        this.textFieldTableXmpPhotoshopFilter = new JTextField();
        this.scrollPaneXmpPhotoshop = new JScrollPane();
        this.tableXmpPhotoshop = new JTable();
        this.panelTableXmpXap = new JPanel();
        this.panelTableXmpXapFilter = new JPanel();
        this.labelTableXmpXapFilter = new JLabel();
        this.textFieldTableXmpXapFilter = new JTextField();
        this.scrollPaneXmpXap = new JScrollPane();
        this.tableXmpXap = new JTable();
        this.panelTableXmpLightroom = new JPanel();
        this.panelTableXmpLightroomFilter = new JPanel();
        this.labelTableXmpLightroomFilter = new JLabel();
        this.textFieldTableXmpLightroomFilter = new JTextField();
        this.scrollPaneXmpLightroom = new JScrollPane();
        this.tableXmpLightroom = new JTable();
        this.panelTableXmpCameraRawSettings = new JPanel();
        this.panelTableXmpCameraRawSettingsFilter = new JPanel();
        this.labelTableXmpCameraRawSettingsFilter = new JLabel();
        this.textFieldTableXmpCameraRawSettingsFilter = new JTextField();
        this.scrollPaneXmpCameraRawSettings = new JScrollPane();
        this.tableXmpCameraRawSettings = new JTable();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.tabbedPaneXmp.setName("tabbedPaneXmp");
        this.tabbedPaneXmp.setOpaque(true);
        this.panelTableXmpTiff.setName("panelTableXmpTiff");
        this.panelTableXmpTiff.setLayout(new GridBagLayout());
        this.panelTableXmpTiffFilter.setName("panelTableXmpTiffFilter");
        this.panelTableXmpTiffFilter.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/xmpmodule/Bundle");
        this.labelTableXmpTiffFilter.setText(bundle.getString("XmpPanel.labelTableXmpTiffFilter.text"));
        this.labelTableXmpTiffFilter.setName("labelTableXmpTiffFilter");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpTiffFilter.add((Component)this.labelTableXmpTiffFilter, gridBagConstraints);
        this.textFieldTableXmpTiffFilter.setName("textFieldTableXmpTiffFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpTiffFilter.add((Component)this.textFieldTableXmpTiffFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpTiff.add((Component)this.panelTableXmpTiffFilter, gridBagConstraints);
        this.scrollPaneXmpTiff.setName("scrollPaneXmpTiff");
        this.tableXmpTiff.setAutoCreateRowSorter(true);
        this.tableXmpTiff.setAutoResizeMode(0);
        this.tableXmpTiff.setName("tableXmpTiff");
        this.scrollPaneXmpTiff.setViewportView(this.tableXmpTiff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpTiff.add((Component)this.scrollPaneXmpTiff, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpTiff.TabConstraints.tabTitle"), this.panelTableXmpTiff);
        this.panelTableXmpExif.setName("panelTableXmpExif");
        this.panelTableXmpExif.setLayout(new GridBagLayout());
        this.panelTableXmpExifFilter.setName("panelTableXmpExifFilter");
        this.panelTableXmpExifFilter.setLayout(new GridBagLayout());
        this.labelTableXmpExifFilter.setText(bundle.getString("XmpPanel.labelTableXmpExifFilter.text"));
        this.labelTableXmpExifFilter.setName("labelTableXmpExifFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpExifFilter.add((Component)this.labelTableXmpExifFilter, gridBagConstraints);
        this.textFieldTableXmpExifFilter.setName("textFieldTableXmpExifFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpExifFilter.add((Component)this.textFieldTableXmpExifFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpExif.add((Component)this.panelTableXmpExifFilter, gridBagConstraints);
        this.scrollPaneXmpExif.setName("scrollPaneXmpExif");
        this.tableXmpExif.setAutoCreateRowSorter(true);
        this.tableXmpExif.setAutoResizeMode(0);
        this.tableXmpExif.setName("tableXmpExif");
        this.scrollPaneXmpExif.setViewportView(this.tableXmpExif);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpExif.add((Component)this.scrollPaneXmpExif, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpExif.TabConstraints.tabTitle"), this.panelTableXmpExif);
        this.panelTableXmpDc.setName("panelTableXmpDc");
        this.panelTableXmpDc.setLayout(new GridBagLayout());
        this.panelTableXmpDcFilter.setName("panelTableXmpDcFilter");
        this.panelTableXmpDcFilter.setLayout(new GridBagLayout());
        this.labelTableXmpDcFilter.setText(bundle.getString("XmpPanel.labelTableXmpDcFilter.text"));
        this.labelTableXmpDcFilter.setName("labelTableXmpDcFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpDcFilter.add((Component)this.labelTableXmpDcFilter, gridBagConstraints);
        this.textFieldTableXmpDcFilter.setName("textFieldTableXmpDcFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpDcFilter.add((Component)this.textFieldTableXmpDcFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpDc.add((Component)this.panelTableXmpDcFilter, gridBagConstraints);
        this.scrollPaneXmpDc.setName("scrollPaneXmpDc");
        this.tableXmpDc.setAutoCreateRowSorter(true);
        this.tableXmpDc.setAutoResizeMode(0);
        this.tableXmpDc.setName("tableXmpDc");
        this.scrollPaneXmpDc.setViewportView(this.tableXmpDc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpDc.add((Component)this.scrollPaneXmpDc, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpDc.TabConstraints.tabTitle"), this.panelTableXmpDc);
        this.panelTableXmpIptc.setName("panelTableXmpIptc");
        this.panelTableXmpIptc.setLayout(new GridBagLayout());
        this.panelTableXmpIptcFilter.setName("panelTableXmpIptcFilter");
        this.panelTableXmpIptcFilter.setLayout(new GridBagLayout());
        this.labelTableXmpIptcFilter.setText(bundle.getString("XmpPanel.labelTableXmpIptcFilter.text"));
        this.labelTableXmpIptcFilter.setName("labelTableXmpIptcFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpIptcFilter.add((Component)this.labelTableXmpIptcFilter, gridBagConstraints);
        this.textFieldTableXmpIptcFilter.setName("textFieldTableXmpIptcFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpIptcFilter.add((Component)this.textFieldTableXmpIptcFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpIptc.add((Component)this.panelTableXmpIptcFilter, gridBagConstraints);
        this.scrollPaneXmpIptc.setName("scrollPaneXmpIptc");
        this.tableXmpIptc.setAutoCreateRowSorter(true);
        this.tableXmpIptc.setAutoResizeMode(0);
        this.tableXmpIptc.setName("tableXmpIptc");
        this.scrollPaneXmpIptc.setViewportView(this.tableXmpIptc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpIptc.add((Component)this.scrollPaneXmpIptc, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpIptc.TabConstraints.tabTitle"), this.panelTableXmpIptc);
        this.panelTableXmpPhotoshop.setName("panelTableXmpPhotoshop");
        this.panelTableXmpPhotoshop.setLayout(new GridBagLayout());
        this.panelTableXmpPhotoshopFilter.setName("panelTableXmpPhotoshopFilter");
        this.panelTableXmpPhotoshopFilter.setLayout(new GridBagLayout());
        this.labelTableXmpPhotoshopFilter.setText(bundle.getString("XmpPanel.labelTableXmpPhotoshopFilter.text"));
        this.labelTableXmpPhotoshopFilter.setName("labelTableXmpPhotoshopFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpPhotoshopFilter.add((Component)this.labelTableXmpPhotoshopFilter, gridBagConstraints);
        this.textFieldTableXmpPhotoshopFilter.setName("textFieldTableXmpPhotoshopFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpPhotoshopFilter.add((Component)this.textFieldTableXmpPhotoshopFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpPhotoshop.add((Component)this.panelTableXmpPhotoshopFilter, gridBagConstraints);
        this.scrollPaneXmpPhotoshop.setName("scrollPaneXmpPhotoshop");
        this.tableXmpPhotoshop.setAutoCreateRowSorter(true);
        this.tableXmpPhotoshop.setAutoResizeMode(0);
        this.tableXmpPhotoshop.setName("tableXmpPhotoshop");
        this.scrollPaneXmpPhotoshop.setViewportView(this.tableXmpPhotoshop);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpPhotoshop.add((Component)this.scrollPaneXmpPhotoshop, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpPhotoshop.TabConstraints.tabTitle"), this.panelTableXmpPhotoshop);
        this.panelTableXmpXap.setName("panelTableXmpXap");
        this.panelTableXmpXap.setLayout(new GridBagLayout());
        this.panelTableXmpXapFilter.setName("panelTableXmpXapFilter");
        this.panelTableXmpXapFilter.setLayout(new GridBagLayout());
        this.labelTableXmpXapFilter.setText(bundle.getString("XmpPanel.labelTableXmpXapFilter.text"));
        this.labelTableXmpXapFilter.setName("labelTableXmpXapFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpXapFilter.add((Component)this.labelTableXmpXapFilter, gridBagConstraints);
        this.textFieldTableXmpXapFilter.setName("textFieldTableXmpXapFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpXapFilter.add((Component)this.textFieldTableXmpXapFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpXap.add((Component)this.panelTableXmpXapFilter, gridBagConstraints);
        this.scrollPaneXmpXap.setName("scrollPaneXmpXap");
        this.tableXmpXap.setAutoCreateRowSorter(true);
        this.tableXmpXap.setAutoResizeMode(0);
        this.tableXmpXap.setName("tableXmpXap");
        this.scrollPaneXmpXap.setViewportView(this.tableXmpXap);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpXap.add((Component)this.scrollPaneXmpXap, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpXap.TabConstraints.tabTitle"), this.panelTableXmpXap);
        this.panelTableXmpLightroom.setName("panelTableXmpLightroom");
        this.panelTableXmpLightroom.setLayout(new GridBagLayout());
        this.panelTableXmpLightroomFilter.setName("panelTableXmpLightroomFilter");
        this.panelTableXmpLightroomFilter.setLayout(new GridBagLayout());
        this.labelTableXmpLightroomFilter.setText(bundle.getString("XmpPanel.labelTableXmpLightroomFilter.text"));
        this.labelTableXmpLightroomFilter.setName("labelTableXmpLightroomFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpLightroomFilter.add((Component)this.labelTableXmpLightroomFilter, gridBagConstraints);
        this.textFieldTableXmpLightroomFilter.setName("textFieldTableXmpLightroomFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpLightroomFilter.add((Component)this.textFieldTableXmpLightroomFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpLightroom.add((Component)this.panelTableXmpLightroomFilter, gridBagConstraints);
        this.scrollPaneXmpLightroom.setName("scrollPaneXmpLightroom");
        this.tableXmpLightroom.setAutoCreateRowSorter(true);
        this.tableXmpLightroom.setAutoResizeMode(0);
        this.tableXmpLightroom.setName("tableXmpLightroom");
        this.scrollPaneXmpLightroom.setViewportView(this.tableXmpLightroom);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpLightroom.add((Component)this.scrollPaneXmpLightroom, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpLightroom.TabConstraints.tabTitle"), this.panelTableXmpLightroom);
        this.panelTableXmpCameraRawSettings.setName("panelTableXmpCameraRawSettings");
        this.panelTableXmpCameraRawSettings.setLayout(new GridBagLayout());
        this.panelTableXmpCameraRawSettingsFilter.setName("panelTableXmpCameraRawSettingsFilter");
        this.panelTableXmpCameraRawSettingsFilter.setLayout(new GridBagLayout());
        this.labelTableXmpCameraRawSettingsFilter.setText(bundle.getString("XmpPanel.labelTableXmpCameraRawSettingsFilter.text"));
        this.labelTableXmpCameraRawSettingsFilter.setName("labelTableXmpCameraRawSettingsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableXmpCameraRawSettingsFilter.add((Component)this.labelTableXmpCameraRawSettingsFilter, gridBagConstraints);
        this.textFieldTableXmpCameraRawSettingsFilter.setName("textFieldTableXmpCameraRawSettingsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableXmpCameraRawSettingsFilter.add((Component)this.textFieldTableXmpCameraRawSettingsFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTableXmpCameraRawSettings.add((Component)this.panelTableXmpCameraRawSettingsFilter, gridBagConstraints);
        this.scrollPaneXmpCameraRawSettings.setName("scrollPaneXmpCameraRawSettings");
        this.tableXmpCameraRawSettings.setAutoCreateRowSorter(true);
        this.tableXmpCameraRawSettings.setAutoResizeMode(0);
        this.tableXmpCameraRawSettings.setName("tableXmpCameraRawSettings");
        this.scrollPaneXmpCameraRawSettings.setViewportView(this.tableXmpCameraRawSettings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTableXmpCameraRawSettings.add((Component)this.scrollPaneXmpCameraRawSettings, gridBagConstraints);
        this.tabbedPaneXmp.addTab(bundle.getString("XmpPanel.panelTableXmpCameraRawSettings.TabConstraints.tabTitle"), this.panelTableXmpCameraRawSettings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPaneXmp, gridBagConstraints);
    }

    public static class XmpTableCellRenderer
    implements TableCellRenderer {
        private static final String DELIMITER_PATH = "/";
        private static final String DELIMITER_NAMESPACE = ":";
        private static final Translation TRANSLATION_XMP = new Translation(XmpTableCellRenderer.class, "XmpPropertyTranslations");
        private final TableLookAndFeel lookAndFeel = (TableLookAndFeel)Lookup.getDefault().lookup(TableLookAndFeel.class);
        private final JLabel cellLabel = new JLabel();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String css;
            if (this.lookAndFeel == null) {
                return new JLabel(StringUtil.toStringNullToEmptyString((Object)value));
            }
            XMPPropertyInfo xmpPropertyInfo = (XMPPropertyInfo)value;
            this.lookAndFeel.setTableCellColor((JComponent)this.cellLabel, isSelected);
            boolean isRowHeader = column == 0;
            int maxChars = isRowHeader ? this.lookAndFeel.getRowHeaderMaxChars() : this.lookAndFeel.getCellMaxChars();
            String string = css = isRowHeader ? this.lookAndFeel.getRowHeaderCss() : this.lookAndFeel.getCellCss();
            if (column == 0) {
                this.lookAndFeel.setTableRowHeaderFont((JComponent)this.cellLabel);
                String xmpPath = xmpPropertyInfo.getPath();
                String text = XmpTableCellRenderer.translate(xmpPath, xmpPath);
                TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)text, (int)maxChars, (String)css);
            } else {
                this.lookAndFeel.setTableCellFont((JComponent)this.cellLabel);
                String text = xmpPropertyInfo.getValue().toString();
                TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)text, (int)maxChars, (String)css);
            }
            return this.cellLabel;
        }

        private static String translate(String path, String alternate) {
            StringBuilder newPath = new StringBuilder();
            List<String> pathComponents = XmpTableCellRenderer.getPathComponents(path);
            int pathComponentsCount = pathComponents.size();
            for (int i = 0; i < pathComponentsCount; ++i) {
                String pathComponent = pathComponents.get(i);
                String withoutIndex = XmpTableCellRenderer.getWithoutIndex(pathComponent);
                String translated = TRANSLATION_XMP.translate(withoutIndex, alternate);
                newPath.append(XmpTableCellRenderer.getWithoutNamespace(translated)).append(XmpTableCellRenderer.getIndexString(pathComponent)).append(pathComponentsCount > 1 && i < pathComponentsCount - 1 ? DELIMITER_PATH : "");
            }
            return newPath.toString();
        }

        private static List<String> getPathComponents(String path) {
            ArrayList<String> components = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(path, DELIMITER_PATH);
            while (tokenizer.hasMoreTokens()) {
                components.add(tokenizer.nextToken());
            }
            return components;
        }

        private static String getWithoutIndex(String string) {
            if (XmpTableCellRenderer.hasIndex(string)) {
                int startIndex = string.lastIndexOf(91);
                return string.substring(0, startIndex);
            }
            return string;
        }

        private static String getIndexString(String string) {
            if (XmpTableCellRenderer.hasIndex(string)) {
                int startIndex = string.lastIndexOf(91);
                return string.substring(startIndex);
            }
            return "";
        }

        private static boolean hasIndex(String string) {
            return string.matches("..*\\[[0-9]+\\]$");
        }

        private static String getWithoutNamespace(String string) {
            if (XmpTableCellRenderer.hasNamespace(string)) {
                int indexDelim = string.indexOf(DELIMITER_NAMESPACE);
                return string.substring(indexDelim + 1);
            }
            return string;
        }

        private static boolean hasNamespace(String string) {
            int indexDelim = string.indexOf(DELIMITER_NAMESPACE);
            if (indexDelim > 0) {
                return XmpMetadata.isKnownNamespace((String)string.substring(0, indexDelim));
            }
            return false;
        }

        private static boolean isExifNamespace(String string) {
            return string.startsWith("exif:");
        }

        public static Comparator<?> createColumn0Comparator() {
            return new Column0Comparator();
        }

        public static Comparator<?> createColumn1Comparator() {
            return new Column1Comparator();
        }

        public static TableStringConverter createTableStringConverter() {
            return new XmpTableStringConverter();
        }

        private static class XmpTableStringConverter
        extends TableStringConverter {
            private XmpTableStringConverter() {
            }

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                if (value instanceof XMPPropertyInfo) {
                    XMPPropertyInfo xmpPropertyInfo = (XMPPropertyInfo)value;
                    String xmpPath = xmpPropertyInfo.getPath();
                    return column == 0 ? XmpTableCellRenderer.translate(xmpPath, xmpPath) : xmpPropertyInfo.getValue().toString();
                }
                return StringUtil.toStringNullToEmptyString((Object)value);
            }
        }

        private static class Column1Comparator
        implements Comparator<Object> {
            private Column1Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof XMPPropertyInfo && o2 instanceof XMPPropertyInfo) {
                    XMPPropertyInfo xmpPropertyInfo1 = (XMPPropertyInfo)o1;
                    XMPPropertyInfo xmpPropertyInfo2 = (XMPPropertyInfo)o2;
                    String o1String = xmpPropertyInfo1.getValue().toString();
                    String o2String = xmpPropertyInfo2.getValue().toString();
                    return o1String.compareToIgnoreCase(o2String);
                }
                return 0;
            }
        }

        private static class Column0Comparator
        implements Comparator<Object> {
            private Column0Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof XMPPropertyInfo && o2 instanceof XMPPropertyInfo) {
                    XMPPropertyInfo xmpPropertyInfo1 = (XMPPropertyInfo)o1;
                    XMPPropertyInfo xmpPropertyInfo2 = (XMPPropertyInfo)o2;
                    String xmpPath1 = xmpPropertyInfo1.getPath();
                    String xmpPath2 = xmpPropertyInfo2.getPath();
                    String o1String = XmpTableCellRenderer.translate(xmpPath1, xmpPath1);
                    String o2String = XmpTableCellRenderer.translate(xmpPath2, xmpPath2);
                    return o1String.compareToIgnoreCase(o2String);
                }
                return 0;
            }
        }
    }
}

