/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.windows.MainWindowComponent;
import org.jphototagger.api.windows.MainWindowComponentProvider;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.TabInEditWindowDisplayedEvent;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.xmpmodule.ModuleInstaller;
import org.jphototagger.xmpmodule.XmpPanel;
import org.openide.util.Lookup;

public final class XmpMetaDataDisplayer
implements MainWindowComponentProvider {
    private final XmpPanel xmpPanel = new XmpPanel();
    private File selectedFile;
    private File displayedFile;
    private boolean xmpPanelDisplayed;

    public XmpMetaDataDisplayer() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        List selectedFiles = evt.getSelectedFiles();
        if (selectedFiles.size() == 1) {
            this.selectedFile = (File)CollectionUtil.getFirstElement((Collection)selectedFiles);
            this.displaySelectedFile();
        } else {
            this.selectedFile = null;
            this.displayedFile = null;
            this.xmpPanel.removeAllRows();
        }
    }

    @EventSubscriber(eventClass=TabInEditWindowDisplayedEvent.class)
    public void tabInEditWindowDisplayed(TabInEditWindowDisplayedEvent evt) {
        boolean isDisplayXmp;
        Component selectedTabComponent = evt.getSelectedTabComponent();
        this.xmpPanelDisplayed = selectedTabComponent == this.xmpPanel;
        boolean bl = isDisplayXmp = this.xmpPanelDisplayed && this.selectedFile != null;
        if (isDisplayXmp) {
            this.displaySelectedFile();
        }
    }

    private void displaySelectedFile() {
        if (this.selectedFile == null || !this.xmpPanelDisplayed || ObjectUtil.equals((Object)this.selectedFile, (Object)this.displayedFile)) {
            return;
        }
        this.displayedFile = this.selectedFile;
        DisplayIptcMetaData displayIptcMetaData = new DisplayIptcMetaData(this.selectedFile, this.xmpPanel);
        EventQueueUtil.invokeInDispatchThread((Runnable)displayIptcMetaData);
    }

    public Collection<? extends MainWindowComponent> getMainWindowSelectionComponents() {
        return Collections.emptyList();
    }

    public Collection<? extends MainWindowComponent> getMainWindowEditComponents() {
        return Arrays.asList(new MainWindowComponent(){

            public Component getComponent() {
                return XmpMetaDataDisplayer.this.xmpPanel;
            }

            public Icon getSmallIcon() {
                return IconUtil.getImageIcon(ModuleInstaller.class, (String)"xmp.png");
            }

            public Icon getLargeIcon() {
                return null;
            }

            public int getPosition() {
                return 2;
            }

            public String getTitle() {
                return Bundle.getString(ModuleInstaller.class, (String)"XmpPanel.WindowTitle", (Object[])new Object[0]);
            }

            public String getTooltipText() {
                return null;
            }

            public KeyStroke getOptionalSelectionAccelaratorKey() {
                return null;
            }
        });
    }

    public static class DisplayIptcMetaData
    implements Runnable {
        private final File file;
        private final XmpPanel xmpPanel;
        private static final Logger LOGGER = Logger.getLogger(DisplayIptcMetaData.class.getName());

        public DisplayIptcMetaData(File file, XmpPanel xmpPanel) {
            this.file = file;
            this.xmpPanel = xmpPanel;
        }

        @Override
        public void run() {
            if (this.file == null) {
                return;
            }
            if (this.isXmpPanelSelected()) {
                LOGGER.log(Level.FINEST, "Updating XMP metadata of image file ''{0}'' in GUI table", this.file);
                WaitDisplayer waitDisplayer = (WaitDisplayer)Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                this.xmpPanel.setFile(this.file);
                waitDisplayer.hide();
            }
        }

        private boolean isXmpPanelSelected() {
            MainWindowManager windowManager = (MainWindowManager)Lookup.getDefault().lookup(MainWindowManager.class);
            return windowManager.isEditComponentSelected((Component)this.xmpPanel);
        }
    }
}

