/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filefilter.AppFileFilterProvider;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.io.filefilter.FileChooserFilter;
import org.jphototagger.lib.io.filefilter.RegexFileFilter;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.FileSystemListCellRenderer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.xmpmodule.FileEditor;
import org.openide.util.Lookup;

public final class FileEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DIRECTORY_NAME = "org.jphototagger.program.view.FileEditorDialog.panels.Directory";
    private static final String KEY_INCLUDE_SUBDIRS = "FileEditorPanel.IncludeSubdirs";
    private static final String KEY_REPLACE_EXISTING_FILES = "FileEditorPanel.ReplaceExistingFiles";
    private List<File> selectedFiles = new ArrayList<File>();
    private List<File> selectedDirectories = new ArrayList<File>();
    private File prevSelectedDirectory = new File("");
    private FileEditor fileEditor = new FileEditor();
    private javax.swing.filechooser.FileFilter fileChooserFileFilter = this.createFileChooserFilter();
    private FileFilter dirChooserFileFilter = new RegexFileFilter(".*", ";");
    private String title = "";
    private volatile boolean selectDirs;
    private volatile boolean cancel;
    private volatile boolean isRunning;
    private JButton buttonCancel;
    private JButton buttonSelectFiles;
    private JButton buttonStart;
    private JCheckBox checkBoxIncludeSubdirectories;
    private JCheckBox checkBoxReplaceExistingFiles;
    private JLabel labelCurrentFile;
    private JLabel labelDescription;
    private JLabel labelInfoFiles;
    private JLabel labelPromptCurrentFile;
    private JXList listFiles;
    private JPanel panelOptions;
    private JProgressBar progressBar;
    private JScrollPane scrollPaneListFiles;

    public FileEditorPanel() {
        this.initComponents();
        this.setModeInfo();
        MnemonicUtil.setMnemonics((Container)this);
    }

    public FileEditorPanel(FileEditor fileEditor, boolean selectDirs) {
        if (fileEditor == null) {
            throw new NullPointerException("fileEditor == null");
        }
        this.fileEditor = fileEditor;
        this.selectDirs = selectDirs;
        this.initComponents();
        this.postInitComponents();
    }

    private javax.swing.filechooser.FileFilter createFileChooserFilter() {
        AppFileFilterProvider provider = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
        FileFilter filter = provider.getAcceptedImageFilesFileFilter();
        String description = Bundle.getString(FileEditorPanel.class, (String)"FileEditorPanel.FileChooserFileFilter.Description", (Object[])new Object[0]);
        return new FileChooserFilter(filter, description);
    }

    private void postInitComponents() {
        this.setModeInfo();
    }

    private void setModeInfo() {
        this.setFileButtonText();
    }

    public void setSelectDirs(boolean select) {
        this.selectDirs = select;
        this.setModeInfo();
    }

    public void setFileChooserFilter(javax.swing.filechooser.FileFilter fileChooserFileFilter) {
        if (fileChooserFileFilter == null) {
            throw new NullPointerException("fileChooserFileFilter == null");
        }
        this.fileChooserFileFilter = fileChooserFileFilter;
    }

    public boolean isSelectDirs() {
        return this.selectDirs;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("description == null");
        }
        this.labelDescription.setText(this.asHtml(description));
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title == null");
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private String asHtml(String description) {
        return "<html><p>" + description + "</p></html>";
    }

    public void setFileChooserFileFilter(javax.swing.filechooser.FileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        this.fileChooserFileFilter = filter;
    }

    public void setDirChooserFileFilter(FileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        this.dirChooserFileFilter = filter;
    }

    public void setEditor(FileEditor fileEditor) {
        if (fileEditor == null) {
            throw new NullPointerException("fileEditor == null");
        }
        if (!this.isRunning) {
            this.fileEditor = fileEditor;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private DirectoryChooser.Option[] getDirChooserOptions() {
        return new DirectoryChooser.Option[]{this.getDirChooserOptionShowHiddenDirs(), DirectoryChooser.Option.MULTI_SELECTION};
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private List<File> getFilesOfDirectories(List<File> selectedDirectories) {
        ArrayList<File> selFiles = new ArrayList<File>();
        List<File> selDirs = this.includeSubdirectories(selectedDirectories);
        for (File dir : selDirs) {
            File[] foundFiles = dir.listFiles(this.dirChooserFileFilter);
            if (foundFiles == null) continue;
            selFiles.addAll(Arrays.asList(foundFiles));
        }
        return selFiles;
    }

    private List<File> includeSubdirectories(List<File> dirs) {
        ArrayList<File> allDirs = new ArrayList<File>();
        boolean includeSubDirs = this.checkBoxIncludeSubdirectories.isSelected();
        for (File dir : dirs) {
            allDirs.add(dir);
            if (!includeSubDirs) continue;
            allDirs.addAll(FileUtil.getSubDirectoriesRecursive((File)dir, null, (DirectoryFilter.Option[])new DirectoryFilter.Option[]{this.getDirFilterOptionShowHiddenFiles()}));
        }
        return allDirs;
    }

    private DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return this.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private void handleSelectFilesActionPerformed() {
        Cursor cursor = this.getCursor();
        this.buttonSelectFiles.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.selectDirs) {
            this.selectDirectories();
        } else {
            this.selectFiles();
        }
        boolean hasFiles = !this.selectedFiles.isEmpty();
        this.setCursor(cursor);
        this.buttonSelectFiles.setEnabled(true);
        this.buttonStart.setEnabled(hasFiles);
    }

    private void handleStartActionPerformed() {
        Thread thread = new Thread((Runnable)new EditThread(), "JPhotoTagger: File editor " + this.title);
        thread.start();
    }

    private void selectDirectories() {
        List hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles((String)"UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), this.prevSelectedDirectory, (Collection)hideRootFiles, this.getDirChooserOptions());
        dlg.setPreferencesKey("FileEditorPanel.DirChooser");
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront((Component)this);
        if (dlg.isAccepted()) {
            this.selectedDirectories = dlg.getSelectedDirectories();
            this.selectedFiles = this.getFilesOfDirectories(this.selectedDirectories);
            this.setFilesToList(this.selectedFiles);
            this.prevSelectedDirectory = (File)dlg.getSelectedDirectories().get(0);
        }
    }

    private void selectFiles() {
        JFileChooser fileChooser = new JFileChooser(this.prevSelectedDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(this.fileChooserFileFilter);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.selectedFiles.clear();
            File[] selFiles = fileChooser.getSelectedFiles();
            this.selectedFiles.addAll(Arrays.asList(selFiles));
            this.setFilesToList(this.selectedFiles);
            this.setDirectory(selFiles);
        }
    }

    private void setDirectory(File[] selFiles) {
        if (selFiles.length > 0) {
            this.prevSelectedDirectory = selFiles[0].getParentFile();
        }
    }

    private void setFileButtonText() {
        this.buttonSelectFiles.setText(this.selectDirs ? Bundle.getString(FileEditorPanel.class, (String)"FileEditorPanel.ButtonFiles.DirectoriesText", (Object[])new Object[0]) : Bundle.getString(FileEditorPanel.class, (String)"FileEditorPanel.ButtonFiles.FilesText", (Object[])new Object[0]));
    }

    public void readProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        this.prevSelectedDirectory = new File(prefs.getString(KEY_DIRECTORY_NAME));
        prefs.applyComponentSettings((Component)this, null);
        this.checkBoxIncludeSubdirectories.setSelected(prefs.getBoolean(KEY_INCLUDE_SUBDIRS));
        this.checkBoxReplaceExistingFiles.setSelected(prefs.getBoolean(KEY_REPLACE_EXISTING_FILES));
    }

    public void writeProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setComponent((Component)this, null);
        prefs.setString(KEY_DIRECTORY_NAME, this.prevSelectedDirectory.getAbsolutePath());
        prefs.setToggleButton(KEY_INCLUDE_SUBDIRS, (JToggleButton)this.checkBoxIncludeSubdirectories);
        prefs.setToggleButton(KEY_REPLACE_EXISTING_FILES, (JToggleButton)this.checkBoxReplaceExistingFiles);
    }

    private void setFilesToList(final List<File> fileList) {
        this.listFiles.setModel((ListModel)new AbstractListModel<File>(){
            private static final long serialVersionUID = 1L;
            private final List<File> files;
            {
                this.files = fileList;
            }

            @Override
            public int getSize() {
                return this.files.size();
            }

            @Override
            public File getElementAt(int i) {
                return this.files.get(i);
            }
        });
    }

    private void initComponents() {
        this.labelDescription = new JLabel();
        this.panelOptions = new JPanel();
        this.checkBoxIncludeSubdirectories = new JCheckBox();
        this.checkBoxReplaceExistingFiles = new JCheckBox();
        this.labelInfoFiles = new JLabel();
        this.scrollPaneListFiles = new JScrollPane();
        this.listFiles = new JXList();
        this.progressBar = new JProgressBar();
        this.labelPromptCurrentFile = new JLabel();
        this.labelCurrentFile = new JLabel();
        this.buttonSelectFiles = new JButton();
        this.buttonCancel = new JButton();
        this.buttonStart = new JButton();
        this.setName("Form");
        this.labelDescription.setText("Beschreibung");
        this.labelDescription.setName("labelDescription");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/xmpmodule/Bundle");
        this.panelOptions.setBorder(BorderFactory.createTitledBorder(bundle.getString("FileEditorPanel.panelOptions.border.title")));
        this.panelOptions.setName("panelOptions");
        this.checkBoxIncludeSubdirectories.setText(bundle.getString("FileEditorPanel.checkBoxIncludeSubdirectories.text"));
        this.checkBoxIncludeSubdirectories.setName("checkBoxIncludeSubdirectories");
        this.checkBoxReplaceExistingFiles.setText(bundle.getString("FileEditorPanel.checkBoxReplaceExistingFiles.text"));
        this.checkBoxReplaceExistingFiles.setName("checkBoxReplaceExistingFiles");
        GroupLayout panelOptionsLayout = new GroupLayout(this.panelOptions);
        this.panelOptions.setLayout(panelOptionsLayout);
        panelOptionsLayout.setHorizontalGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOptionsLayout.createSequentialGroup().addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxReplaceExistingFiles).addComponent(this.checkBoxIncludeSubdirectories)).addContainerGap(80, Short.MAX_VALUE)));
        panelOptionsLayout.setVerticalGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelOptionsLayout.createSequentialGroup().addComponent(this.checkBoxIncludeSubdirectories).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxReplaceExistingFiles).addContainerGap(-1, Short.MAX_VALUE)));
        this.labelInfoFiles.setText(bundle.getString("FileEditorPanel.labelInfoFiles.text"));
        this.labelInfoFiles.setName("labelInfoFiles");
        this.scrollPaneListFiles.setName("scrollPaneListFiles");
        this.listFiles.setCellRenderer((ListCellRenderer)new FileSystemListCellRenderer(true));
        this.listFiles.setEnabled(false);
        this.listFiles.setName("listFiles");
        this.scrollPaneListFiles.setViewportView((Component)this.listFiles);
        this.progressBar.setName("progressBar");
        this.labelPromptCurrentFile.setText(bundle.getString("FileEditorPanel.labelPromptCurrentFile.text"));
        this.labelPromptCurrentFile.setName("labelPromptCurrentFile");
        this.labelCurrentFile.setForeground(new Color(0, 0, 255));
        this.labelCurrentFile.setName("labelCurrentFile");
        this.buttonSelectFiles.setText(bundle.getString("FileEditorPanel.buttonSelectFiles.text"));
        this.buttonSelectFiles.setName("buttonSelectFiles");
        this.buttonSelectFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileEditorPanel.this.buttonSelectFilesActionPerformed(evt);
            }
        });
        this.buttonCancel.setText(bundle.getString("FileEditorPanel.buttonCancel.text"));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileEditorPanel.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonStart.setText(bundle.getString("FileEditorPanel.buttonStart.text"));
        this.buttonStart.setEnabled(false);
        this.buttonStart.setName("buttonStart");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileEditorPanel.this.buttonStartActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneListFiles, -1, 453, Short.MAX_VALUE).addComponent(this.panelOptions, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.progressBar, GroupLayout.Alignment.TRAILING, -1, 453, Short.MAX_VALUE).addComponent(this.labelDescription, GroupLayout.Alignment.TRAILING, -1, 453, Short.MAX_VALUE).addComponent(this.labelInfoFiles).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelPromptCurrentFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.buttonSelectFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonStart)).addComponent(this.labelCurrentFile, -1, 355, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.labelDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelInfoFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPaneListFiles, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelPromptCurrentFile).addComponent(this.labelCurrentFile, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonSelectFiles).addComponent(this.buttonStart)).addContainerGap()));
    }

    private void buttonSelectFilesActionPerformed(ActionEvent evt) {
        this.handleSelectFilesActionPerformed();
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.handleStartActionPerformed();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
    }

    private class EditThread
    implements Runnable {
        private EditThread() {
        }

        @Override
        public void run() {
            this.setIsRunning(true);
            FileEditorPanel.this.fileEditor.setConfirmOverwrite(!FileEditorPanel.this.checkBoxReplaceExistingFiles.isSelected());
            int filesCount = FileEditorPanel.this.selectedFiles.size();
            this.initProgressBar(filesCount);
            for (int i = 0; i < filesCount && !FileEditorPanel.this.cancel; ++i) {
                File file = (File)FileEditorPanel.this.selectedFiles.get(i);
                FileEditorPanel.this.fileEditor.edit(file);
                FileEditorPanel.this.labelCurrentFile.setText(file.getAbsolutePath());
                FileEditorPanel.this.progressBar.setValue(i + 1);
            }
            this.setIsRunning(false);
        }

        private void initProgressBar(int count) {
            FileEditorPanel.this.progressBar.setMinimum(0);
            FileEditorPanel.this.progressBar.setMaximum(count);
            FileEditorPanel.this.progressBar.setValue(0);
        }

        private void setIsRunning(boolean runs) {
            FileEditorPanel.this.buttonStart.setEnabled(!runs);
            FileEditorPanel.this.buttonCancel.setEnabled(runs);
            FileEditorPanel.this.buttonSelectFiles.setEnabled(!runs);
            FileEditorPanel.this.checkBoxIncludeSubdirectories.setEnabled(!runs);
            FileEditorPanel.this.checkBoxReplaceExistingFiles.setEnabled(!runs);
            FileEditorPanel.this.labelCurrentFile.setText("");
            FileEditorPanel.this.isRunning = runs;
            FileEditorPanel.this.cancel = false;
        }
    }
}

