/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmpmodule;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.lib.io.FileLock;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.xmp.XmpFileReader;
import org.jphototagger.xmpmodule.FileEditor;
import org.openide.util.Lookup;

public final class ExtractEmbeddedXmp
extends FileEditor {
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    @Override
    public void edit(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (!FileLock.INSTANCE.lockLogWarning(file, (Object)this)) {
            return;
        }
        File sidecarFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(file);
        if (sidecarFile != null && !this.confirmRemove(sidecarFile)) {
            return;
        }
        this.writeSidecarFile(file);
        FileLock.INSTANCE.unlock(file, (Object)this);
    }

    private boolean confirmRemove(File file) {
        if (this.getConfirmOverwrite()) {
            String message = Bundle.getString(ExtractEmbeddedXmp.class, (String)"ExtractEmbeddedXmp.Confirm.Overwrite", (Object[])new Object[]{file});
            return MessageDisplayer.confirmYesNo(null, (String)message);
        }
        return true;
    }

    private void create(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("File couldn't be created: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSidecarFile(File file) {
        String xmp = XmpFileReader.readFile((File)file);
        FileOutputStream fos = null;
        if (xmp != null) {
            try {
                this.create(file);
                fos = new FileOutputStream(this.xmpSidecarFileResolver.suggestXmpSidecarFile(file));
                fos.getChannel().lock();
                fos.write(xmp.getBytes());
                fos.flush();
                this.updateRepository(file);
            }
            catch (Throwable t) {
                Logger.getLogger(ExtractEmbeddedXmp.class.getName()).log(Level.SEVERE, null, t);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable t) {
                        Logger.getLogger(ExtractEmbeddedXmp.class.getName()).log(Level.SEVERE, null, t);
                    }
                }
            }
        }
    }

    private void updateRepository(File imageFile) {
        SaveToOrUpdateFilesInRepository updater = ((SaveToOrUpdateFilesInRepository)Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class)).createInstance(Arrays.asList(imageFile), new SaveOrUpdate[]{SaveOrUpdate.XMP});
        updater.saveOrUpdateWaitForTermination();
    }
}

