/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.xform;

public class XtoByteBE {
    static final int[] SHIFTS_INT_BE;
    static final int[] byte_mask;
    static final int[] shift_mask;

    public static final int intToByte(int[] source, int sourceOffset, byte[] dest, int destOffset) {
        int v2 = source[sourceOffset];
        dest[destOffset++] = (byte)(v2 >> 24 & 0xFF);
        dest[destOffset++] = (byte)(v2 >> 16 & 0xFF);
        dest[destOffset++] = (byte)(v2 >> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static final int intToByte(int v2, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(v2 >> 24 & 0xFF);
        dest[destOffset++] = (byte)(v2 >> 16 & 0xFF);
        dest[destOffset++] = (byte)(v2 >> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static final void intToByte(int[] source, int srcOffset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            int v2 = source[srcOffset + i2];
            dest[destOffset++] = (byte)(v2 >>> 24 & 0xFF);
            dest[destOffset++] = (byte)(v2 >>> 16 & 0xFF);
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
            dest[destOffset++] = (byte)(v2 & 0xFF);
            ++i2;
        }
    }

    public static final void intToByteBE(int[] source, int srcOffset, int count, byte[] dest, int destOffset, int skip) {
        if (skip > 0) {
            int v2 = source[srcOffset++];
            int i2 = skip;
            while (i2 < 4) {
                dest[destOffset++] = (byte)(v2 >>> SHIFTS_INT_BE[i2] & 0xFF);
                ++i2;
            }
        }
        XtoByteBE.intToByte(source, srcOffset, count, dest, destOffset);
    }

    public static int charToByte(char[] source, int srcOffset, byte[] dest, int destOffset) {
        char v2 = source[srcOffset];
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static int charToByte(char v2, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static void charToByte(char[] source, int srcOffset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            char v2 = source[srcOffset + i2];
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
            dest[destOffset++] = (byte)(v2 & 0xFF);
            ++i2;
        }
    }

    public static int doubleToByteBE(double[] source, int srcOffset, byte[] dest, int destOffset) {
        double d2 = source[srcOffset];
        long v2 = Double.doubleToLongBits(d2);
        dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
        dest[destOffset++] = (byte)(v2 & 0xFFL);
        return destOffset;
    }

    public static int doubleToByteBE(double d2, byte[] dest, int destOffset) {
        long v2 = Double.doubleToLongBits(d2);
        dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
        dest[destOffset++] = (byte)(v2 & 0xFFL);
        return destOffset;
    }

    public static void doubleToByteBE(double[] source, int srcOffset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            double d2 = source[srcOffset + i2];
            long v2 = Double.doubleToLongBits(d2);
            dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
            dest[destOffset++] = (byte)(v2 & 0xFFL);
            ++i2;
        }
    }

    public static int floatToByteBE(float[] source, int offset, byte[] dest, int destOffset) {
        float f2 = source[offset];
        int v2 = Float.floatToIntBits(f2);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFF);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFF);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static int floatToByteBE(float f2, byte[] dest, int destOffset) {
        int v2 = Float.floatToIntBits(f2);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFF);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFF);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static void floatToByteBE(float[] source, int offset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            float f2 = source[offset + i2];
            int v2 = Float.floatToIntBits(f2);
            dest[destOffset++] = (byte)(v2 >>> 24 & 0xFF);
            dest[destOffset++] = (byte)(v2 >>> 16 & 0xFF);
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
            dest[destOffset++] = (byte)(v2 & 0xFF);
            ++i2;
        }
    }

    public static int longToByteBE(long[] source, int offset, byte[] dest, int destOffset) {
        long v2 = source[offset];
        dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
        dest[destOffset++] = (byte)(v2 & 0xFFL);
        return destOffset;
    }

    public static int longToByteBE(long v2, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
        dest[destOffset++] = (byte)(v2 & 0xFFL);
        return destOffset;
    }

    public static void longToByteBE(long[] source, int offset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            long v2 = source[offset + i2];
            dest[destOffset++] = (byte)(v2 >>> 56 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 48 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 40 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 32 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 24 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 16 & 0xFFL);
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFFL);
            dest[destOffset++] = (byte)(v2 & 0xFFL);
            ++i2;
        }
    }

    public static int shortToByteBE(short[] source, int offset, byte[] dest, int destOffset) {
        short v2 = source[offset];
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static int shortToByteBE(short v2, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
        dest[destOffset++] = (byte)(v2 & 0xFF);
        return destOffset;
    }

    public static void shortToByteBE(short[] source, int offset, int count, byte[] dest, int destOffset) {
        int i2 = 0;
        while (i2 < count) {
            short v2 = source[offset + i2];
            dest[destOffset++] = (byte)(v2 >>> 8 & 0xFF);
            dest[destOffset++] = (byte)(v2 & 0xFF);
            ++i2;
        }
    }

    public static int shortToByteBE(byte mask, short[] source, int offset, byte[] dest, int destOffset) {
        int bytesInShort = 2;
        short v2 = source[offset];
        int j2 = 0;
        while (j2 < bytesInShort) {
            if ((mask & byte_mask[j2]) != 0) {
                dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInShort - 1 - j2] & 0xFF);
            }
            ++j2;
        }
        return destOffset;
    }

    public static void shortToByteBE(byte mask, short[] source, int offset, int count, byte[] dest, int destOffset) {
        int bytesInShort = 2;
        int i2 = 0;
        while (i2 < count) {
            short v2 = source[offset + i2];
            int j2 = 0;
            while (j2 < bytesInShort) {
                if ((mask & byte_mask[j2]) != 0) {
                    dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInShort - 1 - j2] & 0xFF);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static int intToByteBE(byte mask, int[] source, int offset, byte[] dest, int destOffset) {
        int bytesInInt = 4;
        int v2 = source[offset];
        int j2 = 0;
        while (j2 < bytesInInt) {
            if ((mask & byte_mask[j2]) != 0) {
                dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInInt - 1 - j2] & 0xFF);
            }
            ++j2;
        }
        return destOffset;
    }

    public static void intToByteBE(byte mask, int[] source, int offset, int count, byte[] dest, int destOffset) {
        int bytesInInt = 4;
        int i2 = 0;
        while (i2 < count) {
            int v2 = source[offset + i2];
            int j2 = 0;
            while (j2 < bytesInInt) {
                if ((mask & byte_mask[j2]) != 0) {
                    dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInInt - 1 - j2] & 0xFF);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static int longToByteBE(byte mask, long[] source, int offset, byte[] dest, int destOffset) {
        int bytesInLong = 8;
        long v2 = source[offset];
        int j2 = 0;
        while (j2 < bytesInLong) {
            if ((mask & byte_mask[j2]) != 0) {
                dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInLong - 1 - j2] & 0xFFL);
            }
            ++j2;
        }
        return destOffset;
    }

    public static void longToByteBE(byte mask, long[] source, int offset, int count, byte[] dest, int destOffset) {
        int bytesInLong = 8;
        int i2 = 0;
        while (i2 < count) {
            long v2 = source[offset + i2];
            int j2 = 0;
            while (j2 < bytesInLong) {
                if ((mask & byte_mask[j2]) != 0) {
                    dest[destOffset++] = (byte)(v2 >>> shift_mask[bytesInLong - 1 - j2] & 0xFFL);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public static final int getBytesPerNumber(long mask) {
        int bpi = 0;
        int i2 = 0;
        while (i2 < byte_mask.length) {
            if ((mask & (long)byte_mask[i2]) != 0L) {
                ++bpi;
            }
            ++i2;
        }
        return bpi;
    }

    static {
        int[] nArray = new int[4];
        nArray[0] = 24;
        nArray[1] = 16;
        nArray[2] = 8;
        SHIFTS_INT_BE = nArray;
        byte_mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
        int[] nArray2 = new int[8];
        nArray2[1] = 8;
        nArray2[2] = 16;
        nArray2[3] = 24;
        nArray2[4] = 32;
        nArray2[5] = 40;
        nArray2[6] = 48;
        nArray2[7] = 56;
        shift_mask = nArray2;
    }
}

