/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.test;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.test.Assertions;
import java.io.IOException;
import java.io.InputStream;

public class ComparingRandomAccessInput
implements RandomAccessInput {
    RandomAccessInput r0;
    RandomAccessInput r1;

    public ComparingRandomAccessInput(RandomAccessInput ra1, RandomAccessInput ra2) {
        this.r0 = ra1;
        this.r1 = ra2;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) throws IOException {
        RandomAccessInput c0 = this.r0.createInputChild(offset, length, byteOrder, syncPointer);
        RandomAccessInput c1 = this.r1.createInputChild(offset, length, byteOrder, syncPointer);
        return new ComparingRandomAccessInput(c0, c1);
    }

    public InputStream createInputStream(long offset) {
        InputStream in = this.r0.createInputStream(offset);
        return in;
    }

    public long getChildPosition(InputStream child) {
        return this.r0.getChildPosition(child);
    }

    public void setChildPosition(InputStream child, long position) {
        this.r0.setChildPosition(child, position);
    }

    public int read() throws IOException {
        int a0 = this.r0.read();
        int a1 = this.r1.read();
        Assertions.assertEquals(a0, a1);
        return a0;
    }

    public long skip(long n2) throws IOException {
        long s0 = this.r0.skip(n2);
        long s1 = this.r1.skip(n2);
        Assertions.assertEquals(s0, s1);
        return s0;
    }

    public int read(byte[] b0) throws IOException {
        byte[] b1 = new byte[b0.length];
        int k0 = this.r0.read(b0);
        int k1 = this.r1.read(b1);
        Assertions.assertEquals(k0, k1);
        Assertions.assertEquals(b0, b1);
        return k0;
    }

    public int read(byte[] b0, int off, int len) throws IOException {
        byte[] b1 = new byte[b0.length];
        int k0 = this.r0.read(b0, off, len);
        int k1 = this.r1.read(b1, off, len);
        Assertions.assertEquals(k0, k1);
        Assertions.assertEquals(off, b0, b1);
        return k0;
    }

    public void seek(long offset) throws IOException {
        this.r0.seek(offset);
        this.r1.seek(offset);
    }

    public void close() throws IOException {
        this.r0.close();
        this.r1.close();
    }

    public int getByteOrder() {
        int b0 = this.r0.getByteOrder();
        int b1 = this.r1.getByteOrder();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public void setByteOrder(int byteOrder) {
        this.r0.setByteOrder(byteOrder);
        this.r1.setByteOrder(byteOrder);
    }

    public long getFilePointer() throws IOException {
        long fp0 = this.r0.getFilePointer();
        long fp1 = this.r1.getFilePointer();
        Assertions.assertEquals(fp0, fp1);
        return fp0;
    }

    public long length() throws IOException {
        long e0 = this.r0.length();
        long e1 = this.r1.length();
        Assertions.assertEquals(e0, e1);
        return e0;
    }

    public boolean isBuffered() {
        boolean b0 = this.r0.isBuffered();
        boolean b1 = this.r1.isBuffered();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public void readFully(byte[] b0) throws IOException {
        this.getFilePointer();
        this.r0.readFully(b0);
        byte[] b1 = new byte[b0.length];
        this.r1.readFully(b1);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
    }

    public void readFully(byte[] b0, int off, int len) throws IOException {
        this.getFilePointer();
        this.r0.readFully(b0, off, len);
        byte[] b1 = new byte[b0.length];
        this.r1.readFully(b1, off, len);
        this.getFilePointer();
        Assertions.assertEquals(off, len, b0, b1);
    }

    public int skipBytes(int n2) throws IOException {
        this.getFilePointer();
        int s0 = this.r0.skipBytes(n2);
        int s1 = this.r1.skipBytes(n2);
        this.getFilePointer();
        Assertions.assertEquals(s0, s1);
        return s0;
    }

    public boolean readBoolean() throws IOException {
        this.getFilePointer();
        boolean b0 = this.r0.readBoolean();
        boolean b1 = this.r1.readBoolean();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public byte readByte() throws IOException {
        this.getFilePointer();
        byte b0 = this.r0.readByte();
        byte b1 = this.r1.readByte();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public int readUnsignedByte() throws IOException {
        this.getFilePointer();
        int b0 = this.r0.readUnsignedByte();
        int b1 = this.r1.readUnsignedByte();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public short readShort() throws IOException {
        this.getFilePointer();
        short b0 = this.r0.readShort();
        short b1 = this.r1.readShort();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public int readUnsignedShort() throws IOException {
        this.getFilePointer();
        int b0 = this.r0.readUnsignedShort();
        int b1 = this.r1.readUnsignedShort();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public char readChar() throws IOException {
        this.getFilePointer();
        char b0 = this.r0.readChar();
        char b1 = this.r1.readChar();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public int readInt() throws IOException {
        this.getFilePointer();
        int b0 = this.r0.readInt();
        int b1 = this.r1.readInt();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public long readLong() throws IOException {
        this.getFilePointer();
        long b0 = this.r0.readLong();
        long b1 = this.r1.readLong();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public float readFloat() throws IOException {
        this.getFilePointer();
        float b0 = this.r0.readFloat();
        float b1 = this.r1.readFloat();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public double readDouble() throws IOException {
        this.getFilePointer();
        double b0 = this.r0.readDouble();
        double b1 = this.r1.readDouble();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public String readLine() throws IOException {
        this.getFilePointer();
        String s0 = this.r0.readLine();
        String s1 = this.r1.readLine();
        this.getFilePointer();
        Assertions.assertEquals(s0, s1);
        return s0;
    }

    public String readUTF() throws IOException {
        this.getFilePointer();
        String s0 = this.r0.readUTF();
        String s1 = this.r1.readUTF();
        this.getFilePointer();
        Assertions.assertEquals(s0, s1);
        return s0;
    }

    public byte[] readByteLine() throws IOException {
        this.getFilePointer();
        byte[] s0 = this.r0.readByteLine();
        byte[] s1 = this.r1.readByteLine();
        this.getFilePointer();
        Assertions.assertEquals(s0, s1);
        return s0;
    }

    public int readByteLine(byte[] d0) throws IOException {
        this.getFilePointer();
        int s0 = this.r0.readByteLine(d0);
        byte[] d1 = new byte[d0.length];
        int s1 = this.r1.readByteLine(d1);
        this.getFilePointer();
        Assertions.assertEquals(s0, s1);
        Assertions.assertEquals(0, s0, d0, d1);
        return s0;
    }

    public short readShort(int byteOrder) throws IOException {
        this.getFilePointer();
        short b0 = this.r0.readShort(byteOrder);
        short b1 = this.r1.readShort(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public int readUnsignedShort(int byteOrder) throws IOException {
        this.getFilePointer();
        int b0 = this.r0.readUnsignedShort();
        int b1 = this.r1.readUnsignedShort();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public char readChar(int byteOrder) throws IOException {
        this.getFilePointer();
        char b0 = this.r0.readChar(byteOrder);
        char b1 = this.r1.readChar(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public int readInt(int byteOrder) throws IOException {
        this.getFilePointer();
        int b0 = this.r0.readInt(byteOrder);
        int b1 = this.r1.readInt(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public long readLong(int byteOrder) throws IOException {
        this.getFilePointer();
        long b0 = this.r0.readLong(byteOrder);
        long b1 = this.r1.readLong(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public float readFloat(int byteOrder) throws IOException {
        this.getFilePointer();
        float b0 = this.r0.readFloat(byteOrder);
        float b1 = this.r1.readFloat(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public double readDouble(int byteOrder) throws IOException {
        this.getFilePointer();
        double b0 = this.r0.readDouble(byteOrder);
        double b1 = this.r1.readDouble(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public long readUnsignedInt() throws IOException {
        this.getFilePointer();
        long b0 = this.r0.readUnsignedInt();
        long b1 = this.r1.readUnsignedInt();
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }

    public long readUnsignedInt(int byteOrder) throws IOException {
        this.getFilePointer();
        long b0 = this.r0.readUnsignedInt(byteOrder);
        long b1 = this.r1.readUnsignedInt(byteOrder);
        this.getFilePointer();
        Assertions.assertEquals(b0, b1);
        return b0;
    }
}

