/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.io.RLEInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TargaRLEInputStream
extends RLEInputStream {
    private int numSamples;
    private byte[] value;
    private boolean rawPacket;
    private int pixelSize;
    private int vindex;

    public TargaRLEInputStream(InputStream in, int pixelSize) {
        super(in);
        this.pixelSize = pixelSize;
        this.value = new byte[pixelSize];
    }

    public TargaRLEInputStream(InputStream in, Snapshot sn) {
        super(in);
        this.numSamples = sn.numSamples;
        this.value = (byte[])sn.value.clone();
        this.rawPacket = sn.rawPacket;
        this.pixelSize = sn.pixelSize;
        this.vindex = sn.vindex;
    }

    public Snapshot makeSnapshot() {
        Snapshot sn = new Snapshot();
        sn.numSamples = this.numSamples;
        sn.value = (byte[])this.value.clone();
        sn.rawPacket = this.rawPacket;
        sn.pixelSize = this.pixelSize;
        sn.vindex = this.vindex;
        return sn;
    }

    public int read() throws IOException {
        if (this.numSamples == 0) {
            int v2 = this.in.read();
            if (v2 == -1) {
                return -1;
            }
            if (v2 >> 7 == 1) {
                int i2 = 0;
                while (i2 < this.value.length) {
                    this.value[i2] = (byte)this.in.read();
                    ++i2;
                }
                this.numSamples = ((v2 & 0x7F) + 1) * this.pixelSize;
                this.rawPacket = false;
            } else {
                this.numSamples = (v2 + 1) * this.pixelSize;
                this.rawPacket = true;
            }
        }
        --this.numSamples;
        if (this.rawPacket) {
            return this.in.read();
        }
        int b2 = this.value[this.vindex++] & 0xFF;
        if (this.vindex == this.pixelSize) {
            this.vindex = 0;
        }
        return b2;
    }

    public static class Snapshot {
        private int numSamples;
        private byte[] value;
        private boolean rawPacket;
        private int pixelSize;
        private int vindex;
    }
}

