/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.io.RandomAccessInputStream;
import java.io.IOException;

public class TIFFStripInputStream
extends RandomAccessInputStream {
    int[] stripOffsets;
    int[] stripByteCount;
    int currentStrip = -1;
    long stripLimit;
    int markStrip;

    public TIFFStripInputStream(RandomAccessIO ra, int[] stripByteCount, int[] stripOffsets) {
        super(ra);
        this.stripByteCount = stripByteCount;
        this.stripOffsets = stripOffsets;
    }

    public TIFFStripInputStream(RandomAccessIO ra, long startPos, int[] stripByteCount, int[] stripOffsets) {
        super(ra, startPos);
        this.stripByteCount = stripByteCount;
        this.stripOffsets = stripOffsets;
    }

    protected void checkPos() throws IOException {
        if (this.pos > this.stripLimit || this.currentStrip == -1) {
            if (this.currentStrip >= this.stripOffsets.length) {
                throw new IOException();
            }
            ++this.currentStrip;
            this.stripLimit = this.stripOffsets[this.currentStrip] + this.stripByteCount[this.currentStrip];
            this.pos = this.stripOffsets[this.currentStrip];
        }
        super.checkPos();
    }

    public synchronized int read(byte[] b2, int off, int len) throws IOException {
        return super.read(b2, off, Math.min(len, (int)(this.stripLimit - this.pos)));
    }

    public void mark(int i2) {
        super.mark(i2);
        this.markStrip = this.currentStrip;
    }

    public void reset() throws IOException {
        super.reset();
        this.currentStrip = this.markStrip;
    }

    public long skip(long l2) throws IOException {
        int lsi = this.stripOffsets.length - 1;
        long limit = this.stripOffsets[lsi] + this.stripByteCount[lsi];
        long remaining = l2;
        while (remaining > 0L) {
            this.checkPos();
            long cs = Math.min(remaining, this.stripLimit - this.pos);
            if (cs > limit - this.pos) {
                cs = limit - this.pos;
                remaining -= cs;
                this.pos += cs;
                break;
            }
            remaining -= cs;
            this.pos += cs;
        }
        return l2 - remaining;
    }

    public int available() {
        try {
            return super.available();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    public long getPos() {
        long res = 0L;
        int i2 = 0;
        while (i2 < this.currentStrip) {
            res += (long)this.stripByteCount[i2];
            ++i2;
        }
        return res += (long)this.stripByteCount[this.currentStrip] - ((long)(this.stripByteCount[this.currentStrip] + this.stripOffsets[this.currentStrip]) - this.pos);
    }
}

