/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.IOException;
import java.io.Reader;

public class StringArrayReader
extends Reader {
    private String[] str;
    private int[] ends;
    private int[] starts;
    private int length;
    private int next;
    private int mark;
    int current;

    public StringArrayReader(String[] s2) {
        this.str = s2;
        int i2 = 0;
        while (i2 < s2.length) {
            this.length += s2[i2].length();
            ++i2;
        }
        this.starts = new int[s2.length];
        int i3 = 1;
        while (i3 < s2.length) {
            this.starts[i3] = this.starts[i3 - 1] + s2[i3 - 1].length();
            ++i3;
        }
        this.ends = new int[s2.length];
        this.ends[0] = s2[0].length();
        int i4 = 1;
        while (i4 < s2.length) {
            this.ends[i4] = this.ends[i4 - 1] + s2[i4].length();
            ++i4;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                int n2 = -1;
                Object var3_4 = null;
                return n2;
            }
            if (this.next >= this.ends[this.current]) {
                ++this.current;
            }
            char c2 = this.str[this.current].charAt(this.next++ - this.starts[this.current]);
            Object var3_5 = null;
            return c2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0) throw new IndexOutOfBoundsException();
            if (off > cbuf.length) throw new IndexOutOfBoundsException();
            if (len < 0) throw new IndexOutOfBoundsException();
            if (off + len > cbuf.length) throw new IndexOutOfBoundsException();
            if (off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            if (this.next >= this.ends[this.current]) {
                ++this.current;
            }
            int n2 = Math.min(this.ends[this.current] - this.next, len);
            this.str[this.current].getChars(this.next - this.starts[this.current], this.next - this.starts[this.current] + n2, cbuf, off);
            this.next += n2;
            return n2;
        }
    }

    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                long l2 = 0L;
                Object var6_5 = null;
                return l2;
            }
            if (this.next >= this.ends[this.current]) {
                ++this.current;
            }
            long n2 = Math.min((long)(this.ends[this.current] - this.next), ns);
            this.next = (int)((long)this.next + n2);
            long l3 = n2;
            Object var6_6 = null;
            return l3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = true;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
            if (this.starts[this.current] > this.next) {
                ++this.current;
            }
        }
    }

    public void close() {
        this.str = null;
    }
}

