/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.RandomAccessIO;
import java.io.IOException;
import java.io.OutputStream;

public class RandomAccessOutputStream
extends OutputStream {
    protected RandomAccessIO ra;
    protected long pos;

    public RandomAccessOutputStream(RandomAccessIO ra) {
        this(ra, 0L);
    }

    public RandomAccessOutputStream(RandomAccessIO ra, long startPos) {
        this.ra = ra;
        this.pos = startPos;
    }

    protected void checkPos() throws IOException {
        long fp = this.ra.getFilePointer();
        if (fp != this.pos) {
            this.ra.seek(this.pos);
        }
    }

    public void write(int b2) throws IOException {
        this.checkPos();
        this.writeImpl(b2);
        ++this.pos;
    }

    private void writeImpl(int b2) throws IOException {
        this.ra.write(b2);
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkPos();
        this.ra.write(b2, off, len);
        this.pos += (long)len;
    }

    public void close() throws IOException {
        this.ra = null;
    }
}

