/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.RandomAccessInput;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessInputStream
extends InputStream {
    protected static long MARK_UNDEFINED = -1L;
    protected RandomAccessInput ro;
    protected long pos;
    protected long mark = MARK_UNDEFINED;
    protected long startPos;
    boolean moved;

    public RandomAccessInputStream(RandomAccessInput ro) {
        this(ro, 0L);
    }

    public RandomAccessInputStream(RandomAccessInput ro, long startPos) {
        this.ro = ro;
        this.pos = startPos;
        this.startPos = startPos;
    }

    public synchronized int read() throws IOException {
        this.checkPos();
        int a2 = this.ro.read();
        ++this.pos;
        return a2;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public synchronized int read(byte[] b2, int off, int len) throws IOException {
        this.checkPos();
        if (this.ro == null) {
            return -1;
        }
        int r2 = this.ro.read(b2, off, len);
        this.pos += (long)r2;
        return r2;
    }

    protected void checkPos() throws IOException {
        this.moved = false;
        if (this.ro != null && this.ro.getFilePointer() != this.pos) {
            this.ro.seek(this.pos);
        }
    }

    public void close() throws IOException {
        if (this.moved) {
            this.ro.seek(this.pos);
        }
        this.ro = null;
    }

    public int available() throws IOException {
        return (int)(this.ro.length() - this.pos);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int i2) {
        this.mark = this.pos;
    }

    public void reset() throws IOException {
        if (this.mark == MARK_UNDEFINED) {
            throw new IOException("mark undefined");
        }
        this.moved = true;
        this.pos = this.mark;
    }

    public long skip(long l2) throws IOException {
        long skip = Math.min(this.ro.length() - this.pos, l2);
        this.pos += skip;
        this.moved = true;
        return skip;
    }
}

