/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class RLEInputStream
extends FilterInputStream {
    boolean finished;

    public RLEInputStream(InputStream in) {
        super(in);
    }

    public int available() throws IOException {
        if (this.finished) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int i2 = off;
        try {
            while (i2 < off + len) {
                int a2 = this.read();
                if (a2 == -1) {
                    --i2;
                    break;
                }
                b2[i2] = (byte)a2;
                ++i2;
            }
        }
        catch (EndOfLineException endOfLineException) {
        }
        catch (EndOfBitmapException endOfBitmapException) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return i2 - off;
    }

    public abstract int read() throws IOException;

    public static class EndOfLineException
    extends IOException {
        public EndOfLineException() {
            super("EndOfLineException");
        }
    }

    public static class EndOfBitmapException
    extends IOException {
        public EndOfBitmapException() {
            super("EndOfBitmapException");
        }
    }

    public static class DeltaRecordException
    extends IOException {
        public final int dx;
        public final int dy;

        public DeltaRecordException(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }
}

