/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.io.RLEInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RLE8InputStream
extends RLEInputStream {
    int numSamples;
    int value;
    boolean copyLiter;
    boolean ignoreByte;

    public RLE8InputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.numSamples == 0) {
            int len;
            if (this.ignoreByte) {
                this.ignoreByte = false;
                this.in.read();
            }
            if ((len = this.in.read()) == 0) {
                this.value = this.in.read();
                switch (this.value) {
                    case 0: {
                        throw new RLEInputStream.EndOfLineException();
                    }
                    case 1: {
                        this.finished = true;
                        throw new RLEInputStream.EndOfBitmapException();
                    }
                    case 2: {
                        int x2 = this.in.read();
                        int y2 = this.in.read();
                        throw new RLEInputStream.DeltaRecordException(x2, y2);
                    }
                }
                this.copyLiter = true;
                this.numSamples = this.value;
                if ((this.numSamples & 1) != 0) {
                    this.ignoreByte = true;
                }
            } else {
                this.numSamples = len;
                this.copyLiter = false;
                this.value = this.in.read();
            }
        }
        --this.numSamples;
        if (this.copyLiter) {
            return this.in.read();
        }
        return this.value;
    }
}

