/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.io.BitInputStream;
import com.imagero.uio.io.BitOutputStream;
import com.imagero.uio.io.ByteArrayOutputStreamExt;
import com.imagero.uio.io.RLEInputStream;
import java.io.IOException;

public class RLE4InputStream
extends RLEInputStream {
    byte[] value = new byte[2];
    BitInputStream bin;
    byte[] buffer = new byte[128];
    int bufferStart;
    int bufferLength;
    ByteArrayOutputStreamExt bout;
    BitOutputStream bitOut;

    public RLE4InputStream(BitInputStream in) {
        super(in);
        this.bin = in;
        this.bin.setBitsToRead(4);
        this.bout = new ByteArrayOutputStreamExt();
        this.bitOut = new BitOutputStream(this.bout);
    }

    public int read() throws IOException {
        if (this.bufferStart >= this.bufferLength) {
            this.fillBuffer();
        }
        if (this.bufferStart >= this.bufferLength) {
            return -1;
        }
        return this.buffer[this.bufferStart++] & 0xFF;
    }

    private void fillBuffer() throws IOException {
        if (this.bout.size() == 0) {
            this.fillBufferImpl();
        }
        this.bufferStart = 0;
        this.bufferLength = this.bout.drain(this.buffer);
    }

    private void fillBufferImpl() throws IOException {
        int len = this.bin.read(8);
        if (len == 0) {
            int value = this.bin.read(8);
            switch (value) {
                case 0: {
                    throw new RLEInputStream.EndOfLineException();
                }
                case 1: {
                    this.finished = true;
                    throw new RLEInputStream.EndOfBitmapException();
                }
                case 2: {
                    int x2 = this.bin.read(8);
                    int y2 = this.bin.read(8);
                    throw new RLEInputStream.DeltaRecordException(x2, y2);
                }
            }
            int skipCount = 0;
            if ((value & 3) != 0) {
                skipCount = (value + 3) / 4 * 4 - value;
            }
            int i2 = 0;
            while (i2 < value) {
                this.bitOut.write(this.bin.read(4), 4);
                ++i2;
            }
            i2 = 0;
            while (i2 < skipCount) {
                this.bin.read(4);
                ++i2;
            }
        } else {
            this.value[0] = (byte)this.bin.read(4);
            this.value[1] = (byte)this.bin.read(4);
            int i3 = 0;
            while (i3 < len) {
                this.bitOut.write(this.value[i3 & 1], 4);
                ++i3;
            }
        }
    }
}

