/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PackBitsOutputStream
extends FilterOutputStream {
    private RunBuffer runs;
    int width;
    int cnt;

    public PackBitsOutputStream(OutputStream out, int width) {
        super(out);
        this.runs = new RunBuffer(out);
        this.width = width;
    }

    public void write(int b2) throws IOException {
        this.put(b2);
    }

    private void put(int b2) throws IOException {
        this.runs.put(b2);
        if (this.cnt++ == this.width) {
            this.flush();
            this.cnt = 0;
        }
    }

    public void write(byte[] b2) throws IOException {
        int i2 = 0;
        while (i2 < b2.length) {
            this.put(b2[i2] & 0xFF);
            ++i2;
        }
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        int i2 = 0;
        while (i2 < len) {
            this.put(b2[off + i2] & 0xFF);
            ++i2;
        }
    }

    public void flush() throws IOException {
        this.runs.flush();
    }

    public void close() throws IOException {
        this.runs.flush();
    }

    static class RunOutputStream
    extends FilterOutputStream {
        int maxRun;
        int rep = -2;
        int count;

        public RunOutputStream(OutputStream out, int maxRun) {
            super(out);
            this.maxRun = maxRun;
        }

        public void write(int b2) throws IOException {
            if (b2 != this.rep) {
                throw new IOException("Rep");
            }
            if (this.count++ == this.maxRun) {
                this.out.write(this.count - 1);
                this.out.write(this.rep);
                this.count = 0;
            }
        }

        public void set(int rep) {
            this.rep = rep;
            this.count = 2;
        }

        public void flush() throws IOException {
            if (this.count != 0) {
                this.out.write(this.count - 1);
                this.out.write(this.rep);
                this.count = 0;
            }
        }
    }

    static class RunBuffer {
        int rep;
        int count;
        OutputStream out;
        RunOutputStream ros;
        private LiteralBuffer lbuf;

        public RunBuffer(OutputStream out) {
            this.out = out;
            this.ros = new RunOutputStream(out, 128);
            this.lbuf = new LiteralBuffer(out);
        }

        public void put(int k2) throws IOException {
            if (this.count == 0) {
                this.rep = k2;
                this.count = 1;
            } else if (this.rep == k2) {
                if (this.count++ == 2) {
                    this.ros.set(this.rep);
                    this.lbuf.flush();
                } else if (this.count > 2) {
                    this.ros.write(this.rep);
                }
            } else {
                if (this.count > 2) {
                    this.ros.flush();
                } else {
                    int i2 = 0;
                    while (i2 < this.count) {
                        this.lbuf.put(this.rep);
                        ++i2;
                    }
                }
                this.rep = k2;
                this.count = 1;
            }
        }

        void flush() throws IOException {
            if (this.count > 0) {
                this.ros.flush();
                int i2 = 0;
                while (i2 < this.count) {
                    this.lbuf.put(this.rep);
                    ++i2;
                }
                this.count = 0;
            }
            this.lbuf.flush();
        }

        void write() throws IOException {
            this.lbuf.flush();
            this.out.write(-(this.count - 1));
            this.out.write(this.rep);
            this.count = 0;
        }
    }

    static class LiteralBuffer {
        byte[] buffer = new byte[129];
        int count;
        OutputStream out;

        public LiteralBuffer(OutputStream out) {
            this.out = out;
        }

        public void put(int k2) throws IOException {
            this.buffer[this.count++] = (byte)k2;
            if (this.count == 128) {
                this.write();
            }
        }

        void write() throws IOException {
            this.out.write(this.count - 1);
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }

        void flush() throws IOException {
            if (this.count > 0) {
                this.write();
            }
        }
    }

    static class PeekInputStream
    extends ByteArrayInputStream {
        int offset;

        public PeekInputStream(byte[] buf) {
            super(buf);
        }

        public PeekInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
            this.offset = offset;
        }

        public int peek(int offset) {
            return this.buf[this.pos + offset];
        }

        public int getPosition() {
            return this.pos - this.offset;
        }

        public void inc() {
            ++this.pos;
        }
    }

    public static class PackBitsApache
    extends FilterOutputStream {
        int bytesPerRow;
        int inMax;
        int inMaxMinus1;
        PeekInputStream input;
        byte[] tmp = new byte[128];
        int wpos;
        byte[] row;

        public PackBitsApache(OutputStream out, int bytesPerRow) {
            super(out);
            this.bytesPerRow = bytesPerRow;
            this.inMax = bytesPerRow - 1;
            this.inMaxMinus1 = this.inMax - 1;
            this.row = new byte[bytesPerRow];
        }

        public void write(int b2) throws IOException {
            this.row[this.wpos++] = (byte)b2;
            if (this.wpos == this.bytesPerRow) {
                this.wpos = 0;
                this.input = new PeekInputStream(this.row);
                this.packBits();
            }
        }

        public void write(byte[] b2) throws IOException {
            this.write(b2, 0, b2.length);
        }

        public void write(byte[] b2, int off, int len) throws IOException {
            int i2 = 0;
            while (i2 < len) {
                this.write(b2[off + i2] & 0xFF);
                ++i2;
            }
        }

        public void flush() throws IOException {
            if (this.wpos > 0) {
                this.input = new PeekInputStream(this.row, 0, this.wpos);
                this.packBits();
            }
        }

        private void packBits() throws IOException {
            while (this.input.getPosition() <= this.inMax) {
                this.doRunLoop();
                this.doLiterLoop();
            }
        }

        private void doLiterLoop() throws IOException {
            int run = 0;
            while (run < 128 && (this.input.getPosition() < this.inMax && this.input.peek(0) != this.input.peek(1) || this.input.getPosition() < this.inMaxMinus1 && this.input.peek(0) != this.input.peek(2))) {
                this.tmp[run++] = (byte)this.input.read();
            }
            if (this.input.getPosition() == this.inMax && run > 0 && run < 128) {
                this.tmp[run++] = (byte)this.input.read();
            }
            if (run > 0) {
                this.out.write(run - 1);
                this.out.write(this.tmp, 0, run);
            } else if (this.input.getPosition() == this.inMax) {
                this.out.write(0);
                this.out.write(this.input.read() & 0xFF);
            }
        }

        private void doRunLoop() throws IOException {
            int run = 1;
            byte replicate = (byte)this.input.peek(0);
            while (run < 127 && this.input.getPosition() < this.inMax && this.input.peek(0) == this.input.peek(1)) {
                ++run;
                this.input.inc();
            }
            if (run > 1) {
                this.input.inc();
                this.out.write(-(run - 1));
                this.out.write(replicate);
            }
        }
    }

    static class PBApache {
        static int compressPackBits(byte[] data, int numRows, int bytesPerRow, byte[] compData) {
            int inOffset = 0;
            int outOffset = 0;
            byte[] tmp = new byte[128];
            int i2 = 0;
            while (i2 < numRows) {
                outOffset = PBApache.packBits(data, inOffset, bytesPerRow, compData, outOffset, tmp);
                inOffset += bytesPerRow;
                ++i2;
            }
            return outOffset;
        }

        private static int packBits(byte[] input, int inOffset, int inCount, byte[] output, int outOffset, byte[] tmp) {
            int inMax = inOffset + inCount - 1;
            int inMaxMinus1 = inMax - 1;
            while (inOffset <= inMax) {
                int run = 1;
                byte replicate = input[inOffset];
                while (run < 127 && inOffset < inMax && input[inOffset] == input[inOffset + 1]) {
                    ++run;
                    ++inOffset;
                }
                if (run > 1) {
                    ++inOffset;
                    output[outOffset++] = (byte)(-(run - 1));
                    output[outOffset++] = replicate;
                }
                run = 0;
                while (run < 128 && (inOffset < inMax && input[inOffset] != input[inOffset + 1] || inOffset < inMaxMinus1 && input[inOffset] != input[inOffset + 2])) {
                    tmp[run++] = input[inOffset++];
                }
                if (inOffset == inMax && run > 0 && run < 128) {
                    tmp[run++] = input[inOffset++];
                }
                if (run > 0) {
                    output[outOffset++] = (byte)(run - 1);
                    int i2 = 0;
                    while (i2 < run) {
                        output[outOffset++] = tmp[i2];
                        ++i2;
                    }
                    continue;
                }
                if (inOffset != inMax) continue;
                output[outOffset++] = 0;
                output[outOffset++] = input[inOffset++];
            }
            return outOffset;
        }

        PBApache() {
        }
    }

    static interface Writer {
        public boolean next(byte var1) throws IOException;

        public byte get();

        public void flush() throws IOException;

        public Writer nextWriter();
    }

    static class Control
    extends FilterOutputStream {
        Run run;
        Liter liter;
        Writer current;
        Writer last;
        int count;
        int max;

        public Control(OutputStream out, int max) {
            super(out);
            this.max = max;
            this.run = new Run(out);
            this.liter = new Liter(out);
            this.run.nextWriter = this.liter;
            this.liter.nextWriter = this.run;
            this.current = this.run;
        }

        public void write(int b2) throws IOException {
            ++this.count;
            if (!this.current.next((byte)b2)) {
                byte n2;
                this.last = this.current;
                this.current = this.current.nextWriter();
                while ((n2 = this.last.get()) != -1) {
                    this.current.next(n2);
                }
            }
            if (this.count == this.max) {
                this.count = 0;
                this.current.flush();
            }
        }

        public void write(byte[] b2, int off, int len) throws IOException {
            int i2 = 0;
            while (i2 < b2.length) {
                this.write(b2[i2] & 0xFF);
                ++i2;
            }
        }
    }

    static class Run
    implements Writer {
        int run;
        int count;
        int w;
        int rep;
        byte last;
        Writer nextWriter;
        OutputStream out;

        public Run(OutputStream out) {
            this.out = out;
        }

        public Writer nextWriter() {
            return this.nextWriter;
        }

        void init(byte rep, int count, int run) {
            this.rep = rep;
            this.run = run;
            this.count = count;
        }

        public byte get() {
            byte tmp = this.last;
            this.last = (byte)-1;
            return tmp;
        }

        public boolean next(byte b2) throws IOException {
            this.last = b2;
            if (this.run == 0) {
                this.rep = b2 & 0xFF;
                ++this.run;
                return true;
            }
            if (b2 == this.rep) {
                ++this.run;
                ++this.count;
                if (this.run == 128) {
                    this.write();
                }
                return true;
            }
            if (this.run > 1) {
                this.write();
            }
            return false;
        }

        private void write() throws IOException {
            this.out.write(-(this.run - 1));
            this.out.write(this.rep);
            this.run = 0;
        }

        public void flush() throws IOException {
            if (this.run > 0) {
                this.write();
            }
        }
    }

    static class Liter
    implements Writer {
        int b0 = -1;
        int b1 = -1;
        int b2 = -1;
        int run;
        int count;
        int max;
        int pos;
        byte[] buffer = new byte[128];
        Writer nextWriter;
        OutputStream out;

        public Liter(OutputStream out) {
            this.out = out;
        }

        public Writer nextWriter() {
            return this.nextWriter;
        }

        public boolean next(byte a2) throws IOException {
            this.b2 = a2 & 0xFF;
            if (this.run > 0 && this.b0 == this.b1 && this.b0 == this.b2) {
                this.write();
                return false;
            }
            this.shift();
            if (this.run == 128) {
                this.write();
            }
            return true;
        }

        void shift() {
            if (this.b0 != -1) {
                this.add(this.b0);
            }
            this.b0 = this.b1;
            this.b1 = this.b2;
            this.b2 = -1;
        }

        public byte get() {
            byte b2 = (byte)this.b0;
            this.b0 = this.b1;
            this.b1 = -1;
            return b2;
        }

        private void add(int b2) {
            this.buffer[this.run++] = (byte)b2;
            ++this.count;
        }

        public void flush() throws IOException {
            if (this.run > 0 && this.run < 128) {
                this.shift();
                this.write();
            } else if (this.run == 0) {
                this.shift();
                this.out.write(0);
                this.out.write(this.buffer[0] & 0xFF);
            }
        }

        private void write() throws IOException {
            if (this.run > 0) {
                this.out.write(this.run - 1);
                this.out.write(this.buffer, 0, this.run);
            }
            this.run = 0;
        }
    }
}

