/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PackBitsInputStream
extends FilterInputStream {
    boolean finished;
    int numSamples;
    int value;
    boolean copyLiter;

    public PackBitsInputStream(InputStream in) {
        super(in);
    }

    public int available() throws IOException {
        if (this.finished) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int i2 = off;
        try {
            while (i2 < off + len) {
                int a2 = this.read();
                if (a2 == -1) {
                    --i2;
                    break;
                }
                b2[i2] = (byte)a2;
                ++i2;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return i2 - off;
    }

    public int read() throws IOException {
        if (this.numSamples == 0) {
            byte l2 = this.read128();
            if (l2 < 0) {
                this.numSamples = -l2 + 1;
                this.copyLiter = false;
                this.value = this.in.read();
            } else {
                this.numSamples = l2 + 1;
                this.copyLiter = true;
            }
        }
        --this.numSamples;
        if (this.copyLiter) {
            return this.in.read();
        }
        return this.value;
    }

    byte read128() throws IOException {
        byte a2;
        while ((a2 = (byte)this.in.read()) == -128) {
        }
        return a2;
    }
}

