/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.Sys;
import java.io.OutputStream;
import java.util.Vector;

public class MultiByteArrayOutputStream
extends OutputStream {
    Vector v;
    int totalCount;
    int sizeX = 1024;
    protected byte[] buf;
    protected int pos;

    public MultiByteArrayOutputStream() {
        this(1024);
    }

    public MultiByteArrayOutputStream(int sizeX) {
        this.sizeX = sizeX;
        this.v = new Vector();
        this.nextArray();
    }

    protected void nextArray() {
        byte[] b2 = new byte[this.sizeX];
        this.v.addElement(b2);
        this.buf = b2;
        this.pos = 0;
    }

    public synchronized void write(byte[] b2, int off, int len) {
        int i2 = off;
        while (i2 < len) {
            this.write(b2[off + i2]);
            ++i2;
        }
    }

    public synchronized void write(int b2) {
        if (this.pos == this.sizeX) {
            this.nextArray();
        }
        ++this.totalCount;
        this.buf[this.pos++] = (byte)(b2 & 0xFF);
    }

    public static void printHex(int value) {
        String s2 = Integer.toHexString(value &= 0xFF);
        if (s2.length() == 1) {
            Sys.out.print("0");
        }
        Sys.out.print(s2);
        Sys.out.print(" ");
    }

    public void reset() {
        this.totalCount = 0;
        this.v = new Vector();
        this.nextArray();
    }

    public Vector getVector() {
        int lastIndex = this.v.size() - 1;
        byte[] b2 = (byte[])this.v.elementAt(lastIndex);
        byte[] b22 = new byte[this.pos];
        System.arraycopy(b2, 0, b22, 0, this.pos);
        this.v.setElementAt(b22, lastIndex);
        return this.v;
    }

    public void flush() {
    }

    public void close() {
    }

    public int length() {
        return (this.v.size() - 1) * this.sizeX + this.pos;
    }
}

