/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    protected int limit;
    int mark;

    public LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    public int available() throws IOException {
        return this.limit;
    }

    public int read() throws IOException {
        if (this.limit-- <= 0) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] b2) throws IOException {
        return this.in.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.limit > 0) {
            int length = Math.min(len, this.limit);
            int res = this.in.read(b2, off, length);
            if (res > 0) {
                this.limit -= res;
            }
            return res;
        }
        return -1;
    }

    public long skip(long n2) throws IOException {
        if (this.limit > 0) {
            long length = Math.min(n2, (long)this.limit);
            long res = this.in.skip(length);
            if (res > 0L) {
                this.limit = (int)((long)this.limit - res);
            }
            return res;
        }
        return -1L;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.limit;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.limit = this.mark;
    }
}

