/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LEDataOutputStream(OutputStream out) {
        super(out);
    }

    public final void writeShort(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public final void writeChar(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public final void writeInt(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
        this.write(value >> 16 & 0xFF);
        this.write(value >> 24 & 0xFF);
    }

    public final void writeLong(long value) throws IOException {
        this.writeInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
        this.writeInt((int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL));
    }

    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBoolean(boolean b2) throws IOException {
        this.out.write(b2 ? 1 : 0);
    }

    public void writeByte(int v2) throws IOException {
        this.write(v2);
    }

    public void writeBytes(String s2) throws IOException {
        int len = s2.length();
        int i2 = 0;
        while (i2 < len) {
            this.out.write((byte)s2.charAt(i2));
            ++i2;
        }
    }

    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        byte[] b2 = new byte[len * 2];
        int index = 0;
        int i2 = 0;
        while (i2 < len) {
            char v2 = s2.charAt(i2);
            b2[index++] = (byte)(v2 & 0xFF);
            b2[index++] = (byte)(v2 >>> 8 & 0xFF);
            ++i2;
        }
        this.write(b2);
    }

    public void writeUTF(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(str.length());
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(str);
        dataOut.flush();
        dataOut.close();
        byte[] b2 = out.toByteArray();
        this.write(b2);
    }
}

