/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.io.IOutils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JpegFilterInputStream
extends FilterInputStream {
    public static final int APP_0 = 224;
    public static final int APP_1 = 225;
    public static final int APP_2 = 226;
    public static final int APP_3 = 227;
    public static final int APP_4 = 228;
    public static final int APP_5 = 229;
    public static final int APP_6 = 230;
    public static final int APP_7 = 231;
    public static final int APP_8 = 232;
    public static final int APP_9 = 233;
    public static final int APP_10 = 234;
    public static final int APP_11 = 235;
    public static final int APP_12 = 236;
    public static final int APP_13 = 237;
    public static final int APP_14 = 238;
    public static final int APP_15 = 239;
    public static final int[] allMarkers = new int[]{224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239};
    public static final int[] defaultMarkers = new int[]{225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239};
    int[] markers;
    private boolean markerOn;

    public static void filterFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        JpegFilterInputStream.filter(in, out);
        IOutils.closeStream(out);
        IOutils.closeStream(in);
    }

    public static void filter(InputStream in, OutputStream out) throws IOException {
        JpegFilterInputStream.filter(in, out, defaultMarkers);
    }

    public static void filter(InputStream in0, OutputStream out, int[] markers) throws IOException {
        JpegFilterInputStream in = new JpegFilterInputStream(in0, markers);
        int a2 = 0;
        while (a2 >= 0) {
            a2 = in.read();
            out.write(a2);
        }
    }

    public static byte[] filter(byte[] data) throws IOException {
        return JpegFilterInputStream.filter(data, defaultMarkers);
    }

    public static byte[] filter(byte[] data, int[] markers) throws IOException {
        ByteArrayInputStream in0 = new ByteArrayInputStream(data);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JpegFilterInputStream.filter(in0, bout, markers);
        return bout.toByteArray();
    }

    public JpegFilterInputStream(InputStream in) {
        this(in, defaultMarkers);
    }

    public JpegFilterInputStream(InputStream in, int[] markers) {
        super(in);
        this.markers = markers;
    }

    public int read() throws IOException {
        int a2 = this.in.read();
        if (!this.markerOn) {
            if (a2 == 255) {
                this.markerOn = true;
            }
            return a2;
        }
        if (this.isAppMarker(a2)) {
            int length = (this.in.read() << 8) + this.in.read() - 2;
            this.in.skip(length);
            int b2 = this.in.read();
            if (b2 != 255) {
                throw new IOException("marker???");
            }
            return this.read();
        }
        this.markerOn = false;
        return a2;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off + len > b2.length || off < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int read = 1;
        int a2 = this.read();
        if (a2 == -1) {
            return -1;
        }
        b2[off] = (byte)a2;
        int i2 = off + 1;
        while (i2 < len) {
            a2 = this.read();
            if (a2 == -1) break;
            ++read;
            b2[i2] = (byte)a2;
            ++i2;
        }
        return read;
    }

    public boolean isAppMarker(int a2) {
        int i2 = 0;
        while (i2 < this.markers.length) {
            if (a2 == this.markers[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

