/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.ReadUtil;
import com.imagero.uio.Sys;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class IOutils {
    private static final int BIG_ENDIAN = 19789;
    private static final int LITTLE_ENDIAN = 18761;
    static final int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    static byte b0 = (byte)48;
    static byte b1 = (byte)49;
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static void closeStream(BufferedWriter bw) {
        try {
            if (bw != null) {
                bw.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(BufferedReader br) {
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(RandomAccessInput ro) {
        try {
            if (ro != null) {
                ro.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeStream(RandomAccessOutput ro) {
        try {
            if (ro != null) {
                ro.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String toBinaryString(byte value) {
        byte[] b2 = new byte[8];
        int cnt = 0;
        int i2 = 7;
        while (i2 > -1) {
            b2[cnt++] = (value & mask[i2]) == 0 ? b0 : b1;
            --i2;
        }
        return new String(b2);
    }

    public static String toBinaryString(char value) {
        byte[] b2 = new byte[16];
        int cnt = 0;
        int i2 = 15;
        while (i2 > -1) {
            b2[cnt++] = (value & mask[i2]) == 0 ? b0 : b1;
            --i2;
        }
        return new String(b2);
    }

    public static String toBinaryString(int value, int length) {
        byte[] b2 = new byte[length];
        int cnt = 0;
        int i2 = length - 1;
        while (i2 > -1) {
            b2[cnt++] = (value >> i2 & 1) == 1 ? b1 : b0;
            --i2;
        }
        return new String(b2);
    }

    public static String toHexString(byte value) {
        return IOutils.toUnsignedString(value & 0xFF, 4);
    }

    private static String toUnsignedString(int i2, int shift) {
        byte[] buf = new byte[]{48, 48};
        int charPos = 2;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[i2 & mask];
        } while ((i2 >>>= shift) != 0);
        return new String(buf);
    }

    public static void printHexByte(int value) {
        IOutils.printHexImpl(value & 0xFFFF, 2);
    }

    public static void printlnHexByte(int value) {
        IOutils.printHexImpl(value & 0xFFFF, 2);
        Sys.out.println("");
    }

    public static void printHexShort(int value) {
        IOutils.printHexImpl(value & 0xFFFF, 4);
    }

    public static void printlnHexShort(int value) {
        IOutils.printHexImpl(value & 0xFFFF, 4);
        Sys.out.println("");
    }

    public static void printHexInt(int value) {
        IOutils.printHexImpl(value & 0xFFFFFFFF, 8);
    }

    public static void printlnHexInt(int value) {
        IOutils.printHexImpl(value & 0xFFFFFFFF, 8);
        Sys.out.println("");
    }

    public static void printHexLong(long value) {
        IOutils.printHexImpl(value & 0xFFFFFFFFFFFFFFFFL, 16);
    }

    public static void printlnHexLong(long value) {
        IOutils.printHexImpl(value & 0xFFFFFFFFFFFFFFFFL, 16);
        Sys.out.println("");
    }

    static void printHexImpl(long value, int length) {
        String s2 = Long.toHexString(value);
        int i2 = 0;
        int size = length - s2.length();
        while (i2 < size) {
            Sys.out.print("0");
            ++i2;
        }
        Sys.out.print(s2);
    }

    static void printHexImpl(int value, int length) {
        String s2 = Integer.toHexString(value);
        if (s2.length() > length) {
            s2 = s2.substring(s2.length() - length);
        }
        int i2 = 0;
        int size = length - s2.length();
        while (i2 < size) {
            Sys.out.print("0");
            ++i2;
        }
        Sys.out.print(s2);
    }

    public static String getExtension(File f2) {
        String s2 = f2.getName();
        return s2.substring(s2.lastIndexOf(".") + 1).toUpperCase();
    }

    public static int readShort4D(InputStream in) throws IOException {
        return ((in.read() & 0xFF) << 8) + (in.read() & 0xFF);
    }

    public static int readShort4D(DataInput in) throws IOException {
        return ((in.readByte() & 0xFF) << 8) + (in.readByte() & 0xFF);
    }

    public static int readShort49(InputStream in) throws IOException {
        return (in.read() & 0xFF) + ((in.read() & 0xFF) << 8);
    }

    public static int readShort49(DataInput in) throws IOException {
        return (in.readByte() & 0xFF) + ((in.readByte() & 0xFF) << 8);
    }

    public static int readInt4D(InputStream in) throws IOException {
        return ((in.read() & 0xFF) << 24) + ((in.read() & 0xFF) << 16) + ((in.read() & 0xFF) << 8) + (in.read() & 0xFF);
    }

    public static int readInt4D(DataInput in) throws IOException {
        int b0 = in.readByte() & 0xFF;
        int b1 = in.readByte() & 0xFF;
        int b2 = in.readByte() & 0xFF;
        int b3 = in.readByte() & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    public static int readInt49(InputStream in) throws IOException {
        return (in.read() & 0xFF) + ((in.read() & 0xFF) << 8) + ((in.read() & 0xFF) << 16) + ((in.read() & 0xFF) << 24);
    }

    public static int readInt49(DataInput in) throws IOException {
        return (in.readByte() & 0xFF) + ((in.readByte() & 0xFF) << 8) + ((in.readByte() & 0xFF) << 16) + ((in.readByte() & 0xFF) << 24);
    }

    public static long readLong4D(InputStream in) throws IOException {
        return ((long)IOutils.readInt4D(in) << 32) + ((long)IOutils.readInt4D(in) & 0xFFFFFFFFL);
    }

    public static long readLong4D(DataInput in) throws IOException {
        return ((long)IOutils.readInt4D(in) << 32) + ((long)IOutils.readInt4D(in) & 0xFFFFFFFFL);
    }

    public static long readLong49(InputStream in) throws IOException {
        return ((long)IOutils.readInt49(in) & 0xFFFFFFFFL) + (long)(IOutils.readInt49(in) << 32);
    }

    public static long readLong49(DataInput in) throws IOException {
        return ((long)IOutils.readInt49(in) & 0xFFFFFFFFL) + (long)(IOutils.readInt49(in) << 32);
    }

    public static byte readSByte(DataInput ro) throws IOException {
        byte b2 = ro.readByte();
        if (b2 < 0) {
            b2 = (byte)(-(~(b2 + 1)));
        }
        return b2;
    }

    public static short readSShort(DataInput ro) throws IOException {
        short b2 = ro.readShort();
        if (b2 < 0) {
            b2 = (short)(-(~(b2 + 1)));
        }
        return b2;
    }

    public static int readSInt(DataInput ro) throws IOException {
        int b2 = ro.readInt();
        if (b2 < 0) {
            b2 = -(~(b2 + 1));
        }
        return b2;
    }

    public static long readSLong(DataInput ro) throws IOException {
        long b2 = ro.readLong();
        if (b2 < 0L) {
            b2 = -(b2 + 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return b2;
    }

    public static void readFullyS(DataInput ro, byte[] b0) throws IOException {
        ro.readFully(b0);
        IOutils.convertFrom2C(b0);
    }

    public static final void convertFrom2C(byte[] b0) {
        int i2 = 0;
        while (i2 < b0.length) {
            if (b0[i2] < 0) {
                b0[i2] = (byte)(-(~(b0[i2] + 1)));
            }
            ++i2;
        }
    }

    public static void readFullyS(RandomAccessInput ro, short[] b0) throws IOException {
        ReadUtil.readFully(ro, b0);
        IOutils.convertFrom2C(b0);
    }

    public static final void convertFrom2C(short[] b0) {
        int i2 = 0;
        while (i2 < b0.length) {
            if (b0[i2] < 0) {
                b0[i2] = (short)(-(~(b0[i2] + 1)));
            }
            ++i2;
        }
    }

    public static void readFullyS(RandomAccessInput ro, int[] b0) throws IOException {
        ReadUtil.readFully(ro, b0);
        IOutils.convertFrom2C(b0);
    }

    public static final void convertFrom2C(int[] b0) {
        int i2 = 0;
        while (i2 < b0.length) {
            if (b0[i2] < 0) {
                b0[i2] = -(~(b0[i2] + 1));
            }
            ++i2;
        }
    }

    public static void readFullyS(RandomAccessInput ro, long[] b0) throws IOException {
        ReadUtil.readFully(ro, b0);
        IOutils.convertFrom2C(b0);
    }

    public static final void convertFrom2C(long[] b0) {
        int i2 = 0;
        while (i2 < b0.length) {
            if (b0[i2] < 0L) {
                b0[i2] = -(b0[i2] + 1L ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++i2;
        }
    }

    public static void readFully(InputStream in, byte[] b2) throws UnexpectedEOFException, IOException {
        IOutils.readFully(in, b2, 0, b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int off, int len) throws UnexpectedEOFException, IOException {
        int count;
        int n2 = 0;
        do {
            if ((count = in.read(b2, off + n2, len - n2)) >= 0) continue;
            throw new UnexpectedEOFException(n2 > 0 ? n2 : 0);
        } while ((n2 += count) < len);
    }

    public static int readFully2(InputStream in, byte[] b2) throws IOException {
        return IOutils.readFully2(in, b2, 0, b2.length);
    }

    public static int readFully2(InputStream in, byte[] b2, int off, int len) throws IOException {
        int count;
        int n2 = 0;
        int cnt0 = 0;
        do {
            if ((count = in.read(b2, off + n2, len - n2)) == 0) {
                if (++cnt0 >= 3) {
                    break;
                }
            } else {
                cnt0 = 0;
            }
            if (count >= 0) continue;
            return n2 == 0 ? -1 : n2;
        } while ((n2 += count) < len);
        return n2;
    }

    public static long copy(long length, InputStream in, OutputStream out) throws IOException {
        long copy = 0L;
        byte[] buffer = new byte[2048];
        while (length > 0L) {
            int read = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            if (read <= 0) break;
            copy += (long)read;
            length -= (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(long length, InputStream in, DataOutput out) throws IOException {
        long copy = 0L;
        byte[] buffer = new byte[2048];
        while (length > 0L) {
            int read = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            if (read <= 0) break;
            copy += (long)read;
            length -= (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(File src, File dest) throws IOException {
        long l2;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            l2 = IOutils.copy((InputStream)in, out);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            IOutils.closeStream(in);
            IOutils.closeStream(out);
            throw throwable;
        }
        IOutils.closeStream(in);
        IOutils.closeStream(out);
        return l2;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        long copy = 0L;
        byte[] buffer = new byte[2048];
        while ((read = in.read(buffer)) > 0) {
            copy += (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(InputStream in, DataOutput out) throws IOException {
        int read;
        long copy = 0L;
        byte[] buffer = new byte[2048];
        while ((read = in.read(buffer)) > 0) {
            copy += (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(RandomAccessInput in, long offset, OutputStream out) throws IOException {
        int read;
        long copy = 0L;
        byte[] buffer = new byte[2048];
        in.seek(offset);
        while ((read = in.read(buffer)) > 0) {
            copy += (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(RandomAccessInput in, long offset, DataOutput out) throws IOException {
        int read;
        long copy = 0L;
        byte[] buffer = new byte[2048];
        in.seek(offset);
        while ((read = in.read(buffer)) > 0) {
            copy += (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(long offset, long length, RandomAccessInput in, OutputStream out) throws IOException {
        long copy = 0L;
        byte[] buffer = new byte[2048];
        in.seek(offset);
        while (length > 0L) {
            int read = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            if (read <= 0) break;
            copy += (long)read;
            length -= (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static long copy(long offset, long length, RandomAccessInput in, DataOutput out) throws IOException {
        long copy = 0L;
        byte[] buffer = new byte[2048];
        in.seek(offset);
        while (length > 0L) {
            int read = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            if (read <= 0) break;
            copy += (long)read;
            length -= (long)read;
            out.write(buffer, 0, read);
        }
        return copy;
    }

    public static int readShort(InputStream in, int byteOrder) throws IOException {
        switch (byteOrder) {
            case 19789: {
                return IOutils.readShort4D(in);
            }
            case 18761: {
                return IOutils.readShort49(in);
            }
        }
        throw new IllegalArgumentException(String.valueOf(byteOrder));
    }

    public static int readShort(DataInput in, int byteOrder) throws IOException {
        switch (byteOrder) {
            case 19789: {
                return IOutils.readShort4D(in);
            }
            case 18761: {
                return IOutils.readShort49(in);
            }
        }
        throw new IllegalArgumentException(String.valueOf(byteOrder));
    }

    public static int readInt(InputStream in, int byteOrder) throws IOException {
        switch (byteOrder) {
            case 19789: {
                return IOutils.readInt4D(in);
            }
            case 18761: {
                return IOutils.readInt49(in);
            }
        }
        throw new IllegalArgumentException(String.valueOf(byteOrder));
    }

    public static int readInt(DataInput in, int byteOrder) throws IOException {
        switch (byteOrder) {
            case 19789: {
                return IOutils.readInt4D(in);
            }
            case 18761: {
                return IOutils.readInt49(in);
            }
        }
        throw new IllegalArgumentException(String.valueOf(byteOrder));
    }

    public static String readFile(File f2) throws IOException {
        StringBuffer sb2 = new StringBuffer();
        FileInputStream in = new FileInputStream(f2);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            IOutils.readFile(reader, sb2);
        }
        finally {
            Object var5_4 = null;
            reader.close();
        }
        return sb2.toString();
    }

    public static StringBuffer readFileSB(File f2) throws IOException {
        FileInputStream in = new FileInputStream(f2);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer sb2 = new StringBuffer();
        try {
            IOutils.readFile(reader, sb2);
        }
        finally {
            Object var5_4 = null;
            reader.close();
        }
        return sb2;
    }

    public static void readFile(BufferedReader reader, StringBuffer sb2) throws IOException {
        String line = null;
        do {
            if ((line = reader.readLine()) == null) continue;
            sb2.append(line);
            sb2.append("\n");
        } while (line != null);
    }
}

