/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HexInputStream
extends FilterInputStream {
    private static final char[] encodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int[] decodeTable = new int[256];
    boolean finished;
    byte[] buffer = new byte[80];
    int count;
    int pos;

    public HexInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            if (this.finished) {
                return -1;
            }
            this.fillBuffer();
        }
        if (this.pos < this.count) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    protected void fillBuffer() {
        int k2 = 0;
        try {
            while (k2 < this.buffer.length) {
                int b0 = this.in.read();
                if (b0 == 13 || b0 == 10) {
                    --k2;
                } else {
                    if (b0 == 62) {
                        ++k2;
                        this.finished = true;
                        break;
                    }
                    int b1 = this.in.read();
                    int d0 = decodeTable[b0];
                    int d1 = decodeTable[b1];
                    if (d0 == -1 || d1 == -1) {
                        --k2;
                    } else {
                        this.buffer[k2] = (byte)(d0 * 16 + d1);
                    }
                }
                ++k2;
            }
        }
        catch (Throwable ex) {
            System.err.println(ex.getMessage());
        }
        this.count = k2;
        this.pos = 0;
    }

    public long skip(long n2) throws IOException {
        long i2 = 0L;
        while (i2 < n2) {
            int a2 = this.read();
            if (a2 == -1) break;
            ++i2;
        }
        return i2;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            return (int)this.skip(len);
        }
        if (len <= 0) {
            return 0;
        }
        int i2 = 0;
        try {
            while (i2 < len) {
                int a2 = this.read();
                if (a2 != -1) {
                    b2[i2] = (byte)a2;
                    ++i2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i2 == 0 ? -1 : i2;
    }

    static {
        int i2 = 0;
        while (i2 < decodeTable.length) {
            HexInputStream.decodeTable[i2] = -1;
            ++i2;
        }
        int j2 = 0;
        while (j2 < encodeTable.length) {
            HexInputStream.decodeTable[HexInputStream.encodeTable[j2]] = j2;
            ++j2;
        }
    }
}

