/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.java.ActionEvent;
import com.imagero.java.ActionListener;
import com.imagero.java.Event;
import com.imagero.java.EventSource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;

public class ByteArrayOutputStreamExt
extends ByteArrayOutputStream {
    private MyEventSource eventSource = new MyEventSource(this);
    public static final String BUFFER_FULL = "buffer full";
    ActionEvent e = new ActionEvent((EventSource)this.eventSource, "buffer full");
    boolean drained;

    public ByteArrayOutputStreamExt() {
        this(1024);
    }

    public ByteArrayOutputStreamExt(int size) {
        super(size);
    }

    public ByteArrayOutputStreamExt(ActionListener l2) {
        this.eventSource.addEventListener(l2);
    }

    public ByteArrayOutputStreamExt(int size, ActionListener l2) {
        super(size);
        this.eventSource.addEventListener(l2);
    }

    protected void fireBufferFullEvent() {
        this.drained = false;
        this.eventSource.post(this.e);
    }

    public synchronized int drain(byte[] dest) {
        int length = Math.min(dest.length, this.count);
        if (length > 0) {
            System.arraycopy(this.buf, 0, dest, 0, length);
            int len = this.count - length;
            if (len > 0) {
                System.arraycopy(this.buf, length, this.buf, 0, len);
            }
            this.count -= length;
        }
        this.drained = true;
        return length;
    }

    public synchronized void write(int b2) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.fireBufferFullEvent();
        }
        super.write(b2);
    }

    public synchronized void write(byte[] b2, int off, int len) {
        int max = this.buf.length - this.count;
        if (max > len) {
            super.write(b2, off, len);
        } else {
            super.write(b2, off, max);
            this.fireBufferFullEvent();
            this.write2(b2, off + max, len - max);
        }
    }

    private void write2(byte[] b2, int off, int len) {
        if (!this.drained) {
            super.write(b2, off, len);
        } else {
            this.drained = false;
            int max = this.buf.length - this.count;
            if (max > len) {
                super.write(b2, off, len);
            } else {
                super.write(b2, off, max);
                this.fireBufferFullEvent();
                this.write2(b2, off + max, len - max);
            }
        }
    }

    public void close() throws IOException {
        this.fireBufferFullEvent();
        super.close();
    }

    public synchronized byte[] drain() {
        byte[] tmp = this.buf;
        this.buf = new byte[0];
        this.count = 0;
        this.drained = true;
        return tmp;
    }

    public synchronized void writeTo(DataOutput out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    private static class MyEventSource
    extends EventSource {
        public MyEventSource(Object source) {
            super(source);
        }

        public void post(Event e2) {
            super.post(e2);
        }
    }
}

