/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.ByteArrayOutputStream;

public class ByteArrayOutputStream2
extends ByteArrayOutputStream {
    public ByteArrayOutputStream2(byte[] buffer) {
        super(0);
        this.buf = buffer;
    }

    public synchronized void write(int b2) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            throw new ArrayIndexOutOfBoundsException(newcount);
        }
        this.buf[this.count] = (byte)b2;
        this.count = newcount;
    }

    public synchronized void write(int b2, int mask) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            throw new ArrayIndexOutOfBoundsException(newcount);
        }
        this.buf[this.count] = (byte)(b2 & mask | this.buf[this.count] & ~mask);
        this.count = newcount;
    }

    public synchronized void write(byte[] b2, int off, int len) {
        if (len == 0) {
            return;
        }
        if (off < 0 || len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException();
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            int max = this.buf.length - this.count;
            System.arraycopy(b2, off, this.buf, this.count, max);
            throw new ArrayIndexOutOfBoundsException(newcount);
        }
        System.arraycopy(b2, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public int getCount() {
        return this.count;
    }

    public int skip(int n2) {
        int p2 = this.count;
        this.seek(p2 + n2);
        return this.count - p2;
    }

    public void seek(int pos) {
        this.count = Math.min(Math.max(pos, 0), this.buf.length - 1);
    }
}

