/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.ByteArrayInputStream;

public class ByteArray2DInputStream
extends ByteArrayInputStream {
    private byte[][] data;
    int current;
    boolean finished;
    int markIndex;

    public ByteArray2DInputStream(byte[][] data) {
        super(data[0]);
        this.data = data;
    }

    public int read() {
        if (this.finished) {
            return -1;
        }
        if (this.pos >= this.count) {
            this.next();
        }
        return super.read();
    }

    private void next() {
        if (this.current + 1 < this.data.length) {
            this.buf = this.data[++this.current];
            this.pos = 0;
            this.count = this.buf.length;
        } else {
            this.finished = true;
        }
    }

    public int read(byte[] buf, int off, int len) {
        int read = 0;
        while (read < len && !this.finished) {
            int rd;
            if (this.pos >= this.count) {
                this.next();
            }
            if ((rd = super.read(buf, off + read, len - read)) <= 0) break;
            read += rd;
        }
        return read;
    }

    public long skip(long ns) {
        long skipped = 0L;
        while (skipped < ns && !this.finished) {
            if (this.pos >= this.count) {
                this.next();
            }
            long skp = super.skip(ns - skipped);
            skipped += skp;
            if (skp == 0L) break;
        }
        return skipped;
    }

    public void mark(int readAheadLimit) {
        this.markIndex = this.current;
        super.mark(readAheadLimit);
    }

    public void reset() {
        this.buf = this.data[this.markIndex];
        super.reset();
        this.finished = false;
    }
}

