/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    int vbits;
    int bitbuf;
    int markBitbuf;
    int markVbits;
    private int bitsToRead = 8;
    boolean invertBitOrder;
    private static byte[] flipTable;

    public BitInputStream(InputStream in) {
        super(in);
    }

    public int getBitsToRead() {
        return this.bitsToRead;
    }

    public void setBitsToRead(int bitsToRead) {
        if (bitsToRead > 32) {
            throw new IllegalArgumentException(String.valueOf(bitsToRead));
        }
        this.bitsToRead = bitsToRead;
    }

    public boolean isInvertBitOrder() {
        return this.invertBitOrder;
    }

    public void setInvertBitOrder(boolean invertBitOrder) {
        this.invertBitOrder = invertBitOrder;
        if (invertBitOrder) {
            BitInputStream.createFlipTable();
        }
    }

    public int read() throws IOException {
        return this.read(this.bitsToRead);
    }

    public int read(int nbits) throws IOException {
        if (nbits == 0) {
            return 0;
        }
        if (nbits > 32) {
            throw new IllegalArgumentException("only 32 bit can be read at once");
        }
        if (nbits > 24) {
            int nbits0 = nbits / 2;
            int nbits1 = nbits - nbits0;
            return this.read(nbits0) << nbits1 | this.read(nbits1);
        }
        if (nbits > this.vbits) {
            this.fillBuffer(nbits);
        }
        if (this.vbits == 0) {
            return -1;
        }
        int ret = this.bitbuf << 32 - this.vbits >>> 32 - nbits;
        this.vbits -= nbits;
        if (this.vbits < 0) {
            this.vbits = 0;
        }
        return ret;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int c2 = this.read();
        if (c2 == -1) {
            return -1;
        }
        b2[off] = (byte)c2;
        int i2 = 1;
        while (i2 < len) {
            c2 = this.read();
            if (c2 == -1) break;
            b2[off + i2] = (byte)c2;
            ++i2;
        }
        return i2;
    }

    public void resetBuffer() {
        this.vbits = 0;
        this.bitbuf = 0;
    }

    public long skip(long n2) throws IOException {
        if (this.vbits == 0) {
            return this.in.skip(n2);
        }
        int b2 = (this.vbits + 7) / 8;
        this.in.skip(n2 - (long)b2);
        int vbits = this.vbits;
        this.resetBuffer();
        this.fillBuffer(vbits);
        return n2;
    }

    public int skipBits(int n2) throws IOException {
        int k2 = n2;
        int nbits = k2 % 8;
        this.read(nbits);
        k2 -= nbits;
        while (k2 > 0) {
            try {
                this.read(8);
                k2 -= 8;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n2;
    }

    public int skipToByteBoundary() throws IOException {
        int nbits = this.vbits % 8;
        this.read(nbits);
        return nbits;
    }

    private void fillBuffer(int nbits) throws IOException {
        while (this.vbits < nbits) {
            int c2 = this.in.read();
            if (c2 == -1) break;
            if (this.invertBitOrder) {
                c2 = flipTable[c2] & 0xFF;
            }
            this.bitbuf = (this.bitbuf << 8) + (c2 & 0xFF);
            this.vbits += 8;
        }
    }

    public int getBitOffset() {
        return 7 - this.vbits % 8;
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markBitbuf = this.bitbuf;
        this.markVbits = this.vbits;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.bitbuf = this.markBitbuf;
        this.vbits = this.markVbits;
    }

    static byte[] getFlipTable() {
        if (flipTable == null) {
            BitInputStream.createFlipTable();
        }
        return flipTable;
    }

    private static void createFlipTable() {
        flipTable = new byte[256];
        int i2 = 0;
        while (i2 < flipTable.length) {
            int b2 = 0;
            int j2 = 0;
            while (j2 < 8) {
                int k2 = i2 >> j2 & 1;
                b2 = b2 << 1 | k2;
                ++j2;
            }
            BitInputStream.flipTable[i2] = (byte)b2;
            ++i2;
        }
    }
}

