/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import com.imagero.uio.FilterDataOutput;
import com.imagero.uio.io.BitInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class BitDataOutputStream
extends FilterDataOutput {
    protected static final int[] mask = new int[64];
    protected int bitbuf;
    protected int vbits;
    private int bitsToWrite = 8;
    protected byte[] flipTable = BitInputStream.getFlipTable();
    protected boolean invertBitOrder;
    protected int fillByte;

    public BitDataOutputStream(DataOutput out) {
        super(out);
    }

    public int getBitsToWrite() {
        return this.bitsToWrite;
    }

    public void setBitsToWrite(int bitsToWrite) {
        this.bitsToWrite = bitsToWrite;
    }

    public boolean isInvertBitOrder() {
        return this.invertBitOrder;
    }

    public void setInvertBitOrder(boolean invertBitOrder) {
        this.invertBitOrder = invertBitOrder;
    }

    public void write(int b2) throws IOException {
        this.write(b2, this.bitsToWrite);
    }

    public void write(int b2, int nbits) throws IOException {
        if (nbits == 0) {
            return;
        }
        int k2 = b2 & mask[nbits];
        this.bitbuf = this.bitbuf << nbits | k2;
        this.vbits += nbits;
        this.write8();
    }

    protected void write8() throws IOException {
        while (this.vbits > 8) {
            int c2 = this.bitbuf << 32 - this.vbits >>> 24;
            this.vbits -= 8;
            if (this.invertBitOrder) {
                c2 = this.flipTable[c2] & 0xFF;
            }
            this.out.write(c2);
        }
    }

    public int getFillByte() {
        return this.fillByte;
    }

    public void setFillByte(int fillByte) {
        this.fillByte = fillByte & 0xFF;
    }

    public void flush() throws IOException {
        this.write8();
        if (this.vbits > 0) {
            this.write(this.fillByte, 8);
        }
        this.vbits = 0;
        this.bitbuf = 0;
    }

    static {
        int i2 = 0;
        while (i2 < mask.length) {
            BitDataOutputStream.mask[i2] = (1 << i2 + 1) - 1;
            ++i2;
        }
    }
}

