/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class App13InputStream
extends FilterInputStream {
    public static final int MARKER = 255;
    public static final int APP_13 = 237;
    private static final byte[] ID8 = "8BIM".getBytes();
    private static final byte[] PHOTOSHOP = "Photoshop3.0".getBytes();
    boolean finished;
    int length;

    public App13InputStream(InputStream in) throws IOException {
        super(in);
    }

    void initBlock() throws IOException {
        this.in.mark(3);
        int marker = this.in.read();
        int app13 = this.in.read();
        if (marker != 255 || app13 != 237) {
            this.finished = true;
            this.in.reset();
            return;
        }
        this.length = this.in.read() << 8 | (this.in.read() & 0xFF) - 2;
        this.in.mark(4);
        byte[] b2 = new byte[4];
        int i2 = 0;
        while (i2 < 4) {
            b2[i2] = (byte)this.in.read();
            ++i2;
        }
        this.in.reset();
        boolean photoshop = true;
        int i3 = 0;
        while (i3 < b2.length) {
            if (b2[i3] != PHOTOSHOP[i3]) {
                photoshop = false;
                break;
            }
            ++i3;
        }
        if (photoshop) {
            int i4 = 0;
            while (i4 < 14) {
                this.in.read();
                ++i4;
            }
            this.length -= 14;
        } else {
            int i5 = 0;
            while (i5 < b2.length) {
                if (b2[i5] != ID8[i5]) {
                    throw new IOException("not App13 stream");
                }
                ++i5;
            }
        }
    }

    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.length == 0) {
            this.initBlock();
            if (this.finished) {
                return -1;
            }
        }
        --this.length;
        return super.read();
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off + len > b2.length || off < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int read = 1;
        int a2 = this.read();
        if (a2 == -1) {
            return -1;
        }
        b2[off] = (byte)a2;
        int i2 = off + 1;
        while (i2 < len) {
            a2 = this.read();
            if (a2 == -1) break;
            ++read;
            b2[i2] = (byte)a2;
            ++i2;
        }
        return read;
    }

    public long skip(long n2) throws IOException {
        long remaining = n2;
        while (remaining > 0L) {
            int a2 = this.read();
            if (a2 == -1) break;
            --remaining;
        }
        return n2 - remaining;
    }

    public int available() throws IOException {
        if (this.finished) {
            return 0;
        }
        if (this.length == 0) {
            this.initBlock();
            if (this.finished) {
                return 0;
            }
        }
        return this.length;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }
}

