/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCII85InputStream
extends FilterInputStream {
    private int index;
    private int n;
    private boolean eof;
    private byte[] ascii = new byte[5];
    private byte[] b = new byte[4];

    public ASCII85InputStream(InputStream is) {
        super(is);
    }

    public final int read() throws IOException {
        if (this.index >= this.n) {
            byte zz;
            byte z2;
            if (this.eof) {
                return -1;
            }
            this.index = 0;
            do {
                if ((zz = (byte)this.in.read()) != -1) continue;
                this.eof = true;
                return -1;
            } while ((z2 = (byte)zz) == 10 || z2 == 13 || z2 == 32);
            if (z2 == 126 || z2 == 120) {
                this.eof = true;
                this.b = null;
                this.ascii = null;
                this.n = 0;
                return -1;
            }
            if (z2 == 122) {
                this.b[3] = 0;
                this.b[2] = 0;
                this.b[1] = 0;
                this.b[0] = 0;
                this.n = 4;
            } else {
                this.ascii[0] = z2;
                int k2 = 1;
                while (k2 < 5) {
                    do {
                        if ((zz = (byte)this.in.read()) != -1) continue;
                        this.eof = true;
                        return -1;
                    } while ((z2 = (byte)zz) == 10 || z2 == 13 || z2 == 32);
                    this.ascii[k2] = z2;
                    if (z2 == 126 || z2 == 120) break;
                    ++k2;
                }
                this.n = k2 - 1;
                if (this.n == 0) {
                    this.eof = true;
                    this.ascii = null;
                    this.b = null;
                    return -1;
                }
                if (k2 < 5) {
                    ++k2;
                    while (k2 < 5) {
                        this.ascii[k2] = 33;
                        ++k2;
                    }
                    this.eof = true;
                }
                long t2 = 0L;
                k2 = 0;
                while (k2 < 5) {
                    z2 = (byte)(this.ascii[k2] - 33);
                    if (z2 < 0 || z2 > 93) {
                        this.n = 0;
                        this.eof = true;
                        this.ascii = null;
                        this.b = null;
                        throw new IOException("Invalid data in Ascii85 stream");
                    }
                    t2 = t2 * 85L + (long)z2;
                    ++k2;
                }
                k2 = 3;
                while (k2 >= 0) {
                    this.b[k2] = (byte)(t2 & 0xFFL);
                    t2 >>>= 8;
                    --k2;
                }
            }
        }
        return this.b[this.index++] & 0xFF;
    }

    public final int read(byte[] data, int offset, int len) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        int i2 = 0;
        while (i2 < len) {
            if (this.index < this.n) {
                data[i2 + offset] = this.b[this.index++];
            } else {
                int t2 = this.read();
                if (t2 == -1) {
                    return i2;
                }
                data[i2 + offset] = (byte)t2;
            }
            ++i2;
        }
        return len;
    }

    public void close() throws IOException {
        this.ascii = null;
        this.eof = true;
        this.b = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long nValue) {
        return 0L;
    }

    public int available() {
        if (this.eof) {
            return 0;
        }
        return 1;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Reset is not supported");
    }
}

