/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.impl;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.UIOStreamBuilder;
import com.imagero.uio.bio.BufferedRandomAccessIO;
import com.imagero.uio.bio.IOCInputStream;
import com.imagero.uio.bio.IOCOutputStream;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.content.RandomAccessFileContent;
import com.imagero.uio.impl.AbstractRandomAccessIO;
import com.imagero.uio.io.IOutils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;

public class RandomAccessFileWrapper
extends AbstractRandomAccessIO {
    RandomAccessFile in;
    IOController controller;
    long offset;
    Long length;
    static /* synthetic */ Class class$java$lang$Long;

    public RandomAccessFileWrapper(RandomAccessFile in, int byteOrder) throws IOException {
        this.in = in;
        this.setByteOrder(byteOrder);
    }

    public RandomAccessFileWrapper(RandomAccessFile in, long offset, int byteOrder) throws IOException {
        if (offset < 0L || offset >= in.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.in = in;
        this.offset = offset;
        this.setByteOrder(byteOrder);
    }

    public RandomAccessFileWrapper(RandomAccessFile in, long offset, long length, int byteOrder) throws IOException {
        if (offset < 0L || offset >= in.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.in = in;
        this.offset = offset;
        this.length = new Long(length);
        this.setByteOrder(byteOrder);
    }

    protected int _read() throws IOException {
        if (this.getFilePointer() >= this.length()) {
            throw new EOFException();
        }
        int i2 = this.in.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i2;
    }

    public void write(int b2) throws IOException {
        this.in.write(b2);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        int max = len;
        if (this.length != null) {
            max = (int)Math.min(Math.max(this.length() - this.getFilePointer(), 0L), (long)len);
        }
        this.in.write(b2, off, max);
    }

    public long getFilePointer() throws IOException {
        if (this.length == null) {
            return this.in.getFilePointer() - this.offset;
        }
        return Math.min(this.length, this.in.getFilePointer() - this.offset);
    }

    public long length() throws IOException {
        if (this.length == null) {
            return this.in.length() - this.offset;
        }
        return Math.min(this.length, this.in.length() - this.offset);
    }

    public void seek(long pos) throws IOException {
        long max = pos;
        if (this.length != null) {
            max = Math.min(Math.max(pos, 0L), this.length);
        }
        this.in.seek(max + this.offset);
    }

    public int read() throws IOException {
        if (this.getFilePointer() >= this.length()) {
            return -1;
        }
        return this.in.read();
    }

    public long skip(long n2) throws IOException {
        int max = (int)Math.min(Math.max(this.length() - this.getFilePointer(), 0L), n2);
        return this.in.skipBytes(max);
    }

    public void close() throws IOException {
        IOutils.closeStream(this.in);
        this.in = null;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int max = (int)Math.min(Math.max(this.length() - this.getFilePointer(), 0L), (long)len);
        if (max == 0) {
            return -1;
        }
        return this.in.read(b2, off, max);
    }

    public void setLength(long newLength) throws IOException {
        block2: {
            if (this.length != null) break block2;
            try {
                Class<?> aClass = Class.forName("java.io.RandomAccessFile");
                Method method = aClass.getMethod("setLength", class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = RandomAccessFileWrapper.class$("java.lang.Long")));
                method.invoke((Object)this.in, new Long(newLength + this.offset));
            }
            catch (Exception exception) {
                if (newLength <= this.in.length()) break block2;
                long pos = this.getFilePointer();
                this.seek(newLength);
                this.write(0);
                this.seek(pos);
            }
        }
    }

    public void readFully(byte[] b2, int off, int len) throws IOException {
        this.in.readFully(b2, off, len);
    }

    public RandomAccessIO createIOChild(long offset, long length, int byteOrder, boolean syncPointer) throws IOException {
        if (this.controller == null) {
            RandomAccessFileContent content = new RandomAccessFileContent(this.in);
            this.controller = new IOController(UIOStreamBuilder.DEFAULT_CHUNK_SIZE, content);
        }
        BufferedRandomAccessIO rio = new BufferedRandomAccessIO(this.controller, offset);
        if (length > 0L) {
            rio.setLength(length);
        }
        return rio;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) throws IOException {
        return this.createIOChild(offset, length, byteOrder, syncPointer);
    }

    public RandomAccessOutput createOutputChild(long offset, int byteOrder, boolean syncPointer) throws IOException {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }

    public InputStream createInputStream(long offset) {
        if (this.controller == null) {
            RandomAccessFileContent bc2 = new RandomAccessFileContent(this.in);
            this.controller = new IOController(UIOStreamBuilder.DEFAULT_CHUNK_SIZE, bc2);
        }
        return new IOCInputStream(this.controller, offset);
    }

    public long getChildPosition(InputStream child) {
        if (child instanceof IOCInputStream) {
            IOCInputStream iocis = (IOCInputStream)child;
            return iocis.getPosition();
        }
        return -1L;
    }

    public void setChildPosition(InputStream child, long position) {
        if (child instanceof IOCInputStream) {
            IOCInputStream iocis = (IOCInputStream)child;
            iocis.seek(position);
        }
    }

    public OutputStream createOutputStream(long offset) {
        if (this.controller == null) {
            RandomAccessFileContent bc2 = new RandomAccessFileContent(this.in);
            this.controller = new IOController(UIOStreamBuilder.DEFAULT_CHUNK_SIZE, bc2);
        }
        return new IOCOutputStream(this.controller, offset);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

