/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.impl;

import com.imagero.uio.impl.RandomAccessFileX;
import java.io.File;
import java.io.IOException;

public class OffsetRandomAccessFile
extends RandomAccessFileX {
    protected long offset;
    protected long length;

    public OffsetRandomAccessFile(File file, String mode, long offset) throws IOException {
        this(file, mode, offset, file.length() - offset);
    }

    public OffsetRandomAccessFile(File file, String mode, long offset, long length) throws IOException {
        super(file, mode);
        this.offset = offset;
        this.length = length;
        this.seek(0L);
    }

    public OffsetRandomAccessFile(String name, String mode, long offset) throws IOException {
        this(new File(name), mode, offset);
    }

    public OffsetRandomAccessFile(String name, String mode, long offset, long length) throws IOException {
        this(new File(name), mode, offset, length);
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException();
        }
        super.seek(pos + this.offset);
    }

    public int read() throws IOException {
        if (this.getFilePointer() >= this.length) {
            return -1;
        }
        return super.read();
    }

    public long length() throws IOException {
        return this.length;
    }

    public long getFilePointer() throws IOException {
        return super.getFilePointer() - this.offset;
    }

    public int skip(int n2) throws IOException {
        return this.skipBytes(n2);
    }
}

