/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.impl;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.Transformer;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractRandomAccessInput
extends InputStream
implements RandomAccessInput {
    protected int byteOrder = 19789;

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(int byteOrder) {
        switch (byteOrder) {
            case 18761: 
            case 19789: {
                this.byteOrder = byteOrder;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(Integer.toHexString(byteOrder)));
            }
        }
    }

    public boolean isBuffered() {
        return false;
    }

    public final int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public final void readFully(byte[] b2) throws IOException {
        this.readFully(b2, 0, b2.length);
    }

    public int skipBytes(int n2) throws IOException {
        return (int)this.skip(n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    public final byte readByte() throws IOException {
        return (byte)this.read();
    }

    public final int readUnsignedByte() throws IOException {
        return this.read();
    }

    public final short readShort() throws IOException {
        return this.readShort(this.byteOrder);
    }

    public final int readUnsignedShort() throws IOException {
        return this.readUnsignedShort(this.byteOrder);
    }

    public final int readUnsignedShort(int byteOrder) throws IOException {
        byte[] b0 = new byte[2];
        this.readFully(b0);
        return Transformer.byteToShort(b0, 0, byteOrder == 19789);
    }

    public final short readShort(int byteOrder) throws IOException {
        byte[] b0 = new byte[2];
        this.readFully(b0);
        return (short)Transformer.byteToShort(b0, 0, byteOrder == 19789);
    }

    public final char readChar() throws IOException {
        return this.readChar(this.byteOrder);
    }

    public final char readChar(int byteOrder) throws IOException {
        byte[] b0 = new byte[2];
        this.readFully(b0);
        return (char)Transformer.byteToChar(b0, 0, byteOrder == 19789);
    }

    public final int readInt() throws IOException {
        return this.readInt(this.byteOrder);
    }

    public final int readInt(int byteOrder) throws IOException {
        byte[] b0 = new byte[4];
        this.readFully(b0);
        return Transformer.byteToInt(b0, 0, byteOrder == 19789);
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(int byteOrder) throws IOException {
        return (long)this.readInt(byteOrder) & 0xFFFFFFFFL;
    }

    public final long readLong() throws IOException {
        return this.readLong(this.byteOrder);
    }

    public final long readLong(int byteOrder) throws IOException {
        byte[] b0 = new byte[8];
        this.readFully(b0);
        return Transformer.byteToLong(b0, 0, byteOrder == 19789);
    }

    public final float readFloat() throws IOException {
        return this.readFloat(this.byteOrder);
    }

    public final float readFloat(int byteOrder) throws IOException {
        byte[] b0 = new byte[4];
        this.readFully(b0);
        return Transformer.byteToFloat(b0, 0, byteOrder == 19789);
    }

    public final double readDouble() throws IOException {
        return this.readDouble(this.byteOrder);
    }

    public final double readDouble(int byteOrder) throws IOException {
        byte[] b0 = new byte[8];
        this.readFully(b0);
        return Transformer.byteToDouble(b0, 0, byteOrder == 19789);
    }

    public final String readLine() throws IOException {
        return new String(this.readByteLine());
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final byte[] readByteLine() throws IOException {
        return Transformer.readByteLine(this);
    }

    public final int readByteLine(byte[] dest) throws IOException {
        return Transformer.readByteLine(this, dest);
    }

    public void readFully(byte[] b2, int off, int len) throws IOException {
        int n2 = 0;
        while (n2 < len) {
            int count = this.read(b2, off + n2, len - n2);
            if (count <= 0) {
                throw new UnexpectedEOFException(n2);
            }
            n2 += count;
        }
    }

    public abstract RandomAccessInput createInputChild(long var1, long var3, int var5, boolean var6) throws IOException;

    public abstract InputStream createInputStream(long var1);

    public abstract long getChildPosition(InputStream var1);

    public abstract void setChildPosition(InputStream var1, long var2);

    public abstract long getFilePointer() throws IOException;

    public abstract long length() throws IOException;

    public abstract void seek(long var1) throws IOException;
}

