/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.impl;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.Transformer;
import com.imagero.uio.impl.AbstractRandomAccessInput;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractRandomAccessIO
extends AbstractRandomAccessInput
implements RandomAccessIO {
    public final void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public final void writeBoolean(boolean v2) throws IOException {
        this.write(v2 ? 1 : 0);
    }

    public final void writeByte(int v2) throws IOException {
        this.write(v2);
    }

    public final void writeShort(int v2) throws IOException {
        this.writeShort(v2, this.byteOrder);
    }

    public final void writeShort(int v2, int byteOrder) throws IOException {
        byte[] dest = new byte[2];
        Transformer.shortToByte((short)v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeChar(int v2) throws IOException {
        this.writeChar(v2, this.byteOrder);
    }

    public final void writeChar(int v2, int byteOrder) throws IOException {
        byte[] dest = new byte[2];
        Transformer.charToByte((char)v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeInt(int v2) throws IOException {
        this.writeInt(v2, this.byteOrder);
    }

    public final void writeInt(int v2, int byteOrder) throws IOException {
        byte[] dest = new byte[4];
        Transformer.intToByte(v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeLong(long v2) throws IOException {
        this.writeLong(v2, this.byteOrder);
    }

    public final void writeLong(long v2, int byteOrder) throws IOException {
        byte[] dest = new byte[8];
        Transformer.longToByte(v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeFloat(float v2) throws IOException {
        this.writeFloat(v2, this.byteOrder);
    }

    public final void writeFloat(float v2, int byteOrder) throws IOException {
        byte[] dest = new byte[4];
        Transformer.floatToByte(v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeDouble(double v2) throws IOException {
        this.writeDouble(v2, this.byteOrder);
    }

    public final void writeDouble(double v2, int byteOrder) throws IOException {
        byte[] dest = new byte[8];
        Transformer.doubleToByte(v2, dest, 0, byteOrder == 19789);
        this.write(dest);
    }

    public final void writeBytes(String s2) throws IOException {
        this.write(s2.getBytes());
    }

    public final void writeChars(String s2) throws IOException {
        int i2 = 0;
        while (i2 < s2.length()) {
            this.writeChar(s2.charAt(i2));
            ++i2;
        }
    }

    public final void writeUTF(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(str.length());
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(str);
        dataOut.flush();
        dataOut.close();
        byte[] b2 = out.toByteArray();
        this.write(b2);
    }

    public void flush() throws IOException {
    }

    public abstract RandomAccessIO createIOChild(long var1, long var3, int var5, boolean var6) throws IOException;

    public abstract RandomAccessOutput createOutputChild(long var1, int var3, boolean var4) throws IOException;

    public abstract OutputStream createOutputStream(long var1);

    public abstract void setLength(long var1) throws IOException;

    public abstract void write(int var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;
}

