/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.blob;

import com.imagero.uio.blob.Blob;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class BlobInputStream
extends ByteArrayInputStream {
    Blob blob;
    long start;
    boolean finished;

    public BlobInputStream(Blob blob) throws IOException {
        super(new byte[2048]);
        this.blob = blob;
        this.fillBuffer();
    }

    public int read() {
        if (this.finished) {
            return -1;
        }
        if (this.available() > 0) {
            return super.read();
        }
        return -1;
    }

    public synchronized long skip(long n2) {
        int k2 = this.available();
        if ((long)k2 < n2) {
            this.fillBuffer();
        }
        return super.skip(n2);
    }

    public synchronized int available() {
        int k2 = super.available();
        if (k2 > 0) {
            return k2;
        }
        this.fillBuffer();
        return super.available();
    }

    public synchronized int read(byte[] b2, int off, int len) {
        if (this.finished) {
            return -1;
        }
        int k2 = this.available();
        return super.read(b2, off, Math.min(k2, len));
    }

    private void fillBuffer() {
        try {
            this.count = this.blob.get(this.start, this.buf);
        }
        catch (UnexpectedEOFException ex) {
            this.count = (int)ex.getCount();
        }
        catch (IOException ex) {
            this.finished = true;
            ex.printStackTrace();
        }
        if (this.count <= 0) {
            this.count = 0;
            this.pos = 0;
            this.finished = true;
            return;
        }
        this.start += (long)this.count;
        this.pos = 0;
    }
}

