/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.blob;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.blob.BlobInputStream;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public abstract class Blob {
    long length;
    private Hashtable properties = new Hashtable();

    public abstract byte[] get(long var1, int var3) throws IOException;

    public abstract int get(long var1, byte[] var3) throws IOException;

    public abstract boolean writable();

    public abstract void set(long var1, byte[] var3) throws IOException;

    public abstract void clear();

    protected boolean lengthKnown() {
        return this.length > 0L;
    }

    protected abstract long computeLength() throws IOException;

    public long getLength() {
        block2: {
            if (this.lengthKnown()) break block2;
            try {
                this.length = this.computeLength();
            }
            catch (IOException ex) {
                System.err.println("Can't compute Blob length. " + ex.getMessage());
            }
        }
        return this.length;
    }

    public InputStream getInputStream() throws IOException {
        return new BlobInputStream(this);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object property) {
        this.properties.put(key, property);
    }

    public static class BaBlob
    extends Blob {
        int offset;
        byte[] blob;
        static final byte[] empty = new byte[0];

        public BaBlob(byte[] blob) {
            this(blob, 0, blob.length);
        }

        public BaBlob(byte[] blob, int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.blob = blob;
        }

        protected long computeLength() {
            return this.length;
        }

        public byte[] get(long start, int length) {
            int len = (int)Math.max(Math.min((long)length, this.length - start), 0L);
            if (len == 0) {
                return empty;
            }
            byte[] dest = new byte[len];
            System.arraycopy(this.blob, (int)start + this.offset, dest, 0, len);
            return dest;
        }

        public int get(long start, byte[] dest) {
            long max = Math.max(Math.min((long)dest.length, this.length - start), 0L);
            if (max > 0L) {
                System.arraycopy(this.blob, (int)start + this.offset, dest, 0, (int)max);
            }
            return (int)max;
        }

        public boolean writable() {
            return true;
        }

        public void set(long start, byte[] data) {
            System.arraycopy(data, 0, this.blob, (int)start, data.length);
        }

        public void clear() {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.blob, this.offset, (int)this.length);
        }
    }

    public static class RoBlob
    extends Blob {
        RandomAccessInput ro;
        long start;

        public RoBlob(RandomAccessInput ro, long start, long length) {
            this.ro = ro;
            this.start = start;
            this.length = length;
        }

        protected long computeLength() {
            return this.length;
        }

        public byte[] get(long start, int length) throws IOException {
            byte[] byArray;
            long pos = this.ro.getFilePointer();
            try {
                byte[] dest = new byte[length];
                this.ro.seek(this.start + start);
                this.ro.readFully(dest);
                byArray = dest;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.ro.seek(pos);
                throw throwable;
            }
            this.ro.seek(pos);
            return byArray;
        }

        public int get(long start, byte[] dest) throws IOException {
            long max = Math.min((long)dest.length, this.length - start);
            long pos = this.ro.getFilePointer();
            try {
                try {
                    this.ro.seek(this.start + start);
                    this.ro.readFully(dest, 0, (int)max);
                }
                catch (UnexpectedEOFException ex) {
                    int n2 = (int)ex.getCount();
                    Object var10_7 = null;
                    this.ro.seek(pos);
                    return n2;
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.ro.seek(pos);
                throw throwable;
            }
            this.ro.seek(pos);
            return (int)max;
        }

        public boolean writable() {
            return this.ro instanceof RandomAccessIO;
        }

        public void set(long start, byte[] data) throws IOException {
            if (this.writable()) {
                RandomAccessIO ra = (RandomAccessIO)this.ro;
                ra.seek(start);
                ra.write(data);
            }
        }

        public void clear() {
        }
    }
}

