/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.Span;
import com.imagero.uio.io.IOutils;
import java.io.EOFException;
import java.io.IOException;

public class SpannedRandomAccessInputContent
extends Content {
    private RandomAccessInput rio;
    Span[] spans;
    long length;
    Span currentSpan;
    long spanOffset;

    public SpannedRandomAccessInputContent(RandomAccessInput rio, Span[] spans) throws IOException {
        this.rio = rio;
        this.spans = spans;
        long rafLength = rio.length();
        int i2 = 0;
        while (i2 < spans.length) {
            Span span = spans[i2];
            if (span.offset > rafLength || span.offset + span.length > rafLength) {
                throw new IOException("Illegal span: " + span.offset + " " + span.length);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < spans.length) {
            this.length += spans[i3].length;
            ++i3;
        }
    }

    void seek(long offset) throws IOException {
        int sp = 0;
        while (offset > 0L) {
            Span span = this.spans[sp++];
            if (offset < span.length) {
                this.currentSpan = span;
                this.spanOffset = offset;
                this.rio.seek(span.offset + offset);
                return;
            }
            offset -= span.length;
        }
    }

    public int load(long offset, int bpos, byte[] b2) throws IOException {
        this.seek(offset);
        long available = this.currentSpan.length - this.spanOffset;
        int len = (int)Math.min(available, (long)(b2.length - bpos));
        if (len > 0) {
            this.rio.readFully(b2, bpos, len);
            return len;
        }
        throw new EOFException();
    }

    public boolean canReload() {
        return true;
    }

    public void close() {
        IOutils.closeStream(this.rio);
    }

    public boolean writable() {
        return false;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
    }

    public long length() throws IOException {
        return this.length;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.rio = null;
    }
}

