/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.Span;
import com.imagero.uio.io.IOutils;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.EOFException;
import java.io.IOException;

public class SpannedRandomAccessIOContent
extends Content {
    private RandomAccessIO rio;
    Span[] spans;
    long length;
    Span currentSpan;
    long spanOffset;

    public SpannedRandomAccessIOContent(RandomAccessIO rio, Span[] spans) throws IOException {
        this.rio = rio;
        this.spans = spans;
        long rafLength = rio.length();
        int i2 = 0;
        while (i2 < spans.length) {
            Span span = spans[i2];
            if (span.offset > rafLength || span.offset + span.length > rafLength) {
                throw new IOException("Illegal span: " + span.offset + " " + span.length);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < spans.length) {
            this.length += spans[i3].length;
            ++i3;
        }
    }

    void seek(long offset) throws IOException {
        int sp = 0;
        while (offset >= 0L) {
            Span span = this.spans[sp++];
            if (offset < span.length) {
                this.currentSpan = span;
                this.spanOffset = offset;
                this.rio.seek(span.offset + offset);
                return;
            }
            offset -= span.length;
        }
    }

    public int load(long offset, int bpos, byte[] b2) throws IOException {
        int read = 0;
        try {
            while (read < b2.length) {
                int r2 = this.loadImpl(offset, b2, bpos);
                offset += (long)r2;
                bpos += r2;
                read += r2;
            }
        }
        catch (Throwable throwable) {}
        return read;
    }

    private int loadImpl(long offset, byte[] b2, int bpos) throws IOException {
        this.seek(offset);
        long available = this.currentSpan.length - this.spanOffset;
        int len = (int)Math.min(available, (long)(b2.length - bpos));
        if (len > 0) {
            this.rio.readFully(b2, bpos, len);
            return len;
        }
        throw new EOFException();
    }

    public boolean canReload() {
        return true;
    }

    public void close() {
        IOutils.closeStream(this.rio);
    }

    public boolean writable() {
        return true;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
        long len = length;
        while (len > 0L) {
            this.seek(offset);
            long available = this.currentSpan.length - this.spanOffset;
            int w2 = (int)Math.min(available, len);
            if (w2 == 0) {
                throw new UnexpectedEOFException((long)length - len);
            }
            this.rio.write(buffer, bpos, w2);
            offset += (long)w2;
            bpos += w2;
            len -= (long)w2;
        }
    }

    public long length() throws IOException {
        return this.length;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.rio = null;
    }
}

