/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.Span;
import com.imagero.uio.impl.RandomAccessFileX;
import com.imagero.uio.io.IOutils;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SpannedRandomAccessFileContent
extends Content {
    private RandomAccessFile raf;
    Span[] spans;
    long length;
    Span currentSpan;
    long spanOffset;

    public SpannedRandomAccessFileContent(File f2, Span[] spans) throws IOException {
        this(f2, SpannedRandomAccessFileContent.getMode(f2), spans);
    }

    public SpannedRandomAccessFileContent(File f2, String mode, Span[] spans) throws IOException {
        this(new RandomAccessFileX(f2, mode), spans);
    }

    static String getMode(File f2) {
        if (!f2.exists() || f2.canWrite()) {
            return "rw";
        }
        return "r";
    }

    public SpannedRandomAccessFileContent(RandomAccessFile raf, Span[] spans) throws IOException {
        this.raf = raf;
        this.spans = spans;
        long rafLength = raf.length();
        int i2 = 0;
        while (i2 < spans.length) {
            Span span = spans[i2];
            if (span.offset > rafLength || span.offset + span.length > rafLength) {
                throw new IOException("Illegal span: " + span.offset + " " + span.length);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < spans.length) {
            this.length += spans[i3].length;
            ++i3;
        }
    }

    void seek(long offset) throws IOException {
        int sp = 0;
        while (offset > 0L) {
            Span span = this.spans[sp++];
            if (offset < span.length) {
                this.currentSpan = span;
                this.spanOffset = offset;
                this.raf.seek(span.offset + offset);
                return;
            }
            offset -= span.length;
        }
    }

    public int load(long offset, int bpos, byte[] b2) throws IOException {
        this.seek(offset);
        long available = this.currentSpan.length - this.spanOffset;
        int len = (int)Math.min(available, (long)(b2.length - bpos));
        if (len > 0) {
            this.raf.readFully(b2, bpos, len);
            return len;
        }
        throw new EOFException();
    }

    public boolean canReload() {
        return true;
    }

    public void close() {
        IOutils.closeStream(this.raf);
    }

    public boolean writable() {
        return true;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
        long len = length;
        while (len > 0L) {
            this.seek(offset);
            long available = this.currentSpan.length - this.spanOffset;
            int w2 = (int)Math.min(available, len);
            if (w2 == 0) {
                throw new UnexpectedEOFException((long)length - len);
            }
            this.raf.write(buffer, bpos, w2);
            offset += (long)w2;
            bpos += w2;
            len -= (long)w2;
        }
    }

    public long length() throws IOException {
        return this.length;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.raf = null;
    }
}

