/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

public class Range {
    long first;
    long last;

    public Range(long first, long last) {
        if (first == last) {
            throw new IllegalArgumentException("Empty range");
        }
        this.first = Math.min(first, last);
        this.last = Math.max(first, last);
    }

    public boolean contains(Range r2) {
        return r2.first >= this.first && r2.last <= this.last;
    }

    public boolean isOverlap(Range r2) {
        return r2.first >= this.first && r2.first <= this.last || r2.last >= this.first && r2.last <= this.last;
    }

    public boolean isNeighbor(Range r2) {
        return r2.last + 1L == this.first || r2.first - 1L == this.last;
    }

    public boolean canJoin(Range r2) {
        return this.isOverlap(r2) || this.isNeighbor(r2);
    }

    public void join(Range r2) {
        if (this.canJoin(r2)) {
            this.first = Math.min(this.first, r2.first);
            this.last = Math.max(this.last, r2.last);
        }
    }
}

