/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.io.IOutils;
import java.io.EOFException;
import java.io.IOException;

public class RandomAccessIOContent
extends Content {
    private RandomAccessIO rio;

    public RandomAccessIOContent(RandomAccessIO rio) throws IOException {
        this.rio = rio;
    }

    public int load(long offset, int bpos, byte[] b2) throws IOException {
        long max = this.rio.length() - offset;
        int len = (int)Math.min(max, (long)(b2.length - bpos));
        if (len > 0) {
            this.rio.seek(offset);
            this.rio.readFully(b2, bpos, len);
            return len;
        }
        throw new EOFException();
    }

    public boolean canReload() {
        return true;
    }

    public void close() {
        IOutils.closeStream(this.rio);
        this.rio = null;
    }

    public boolean writable() {
        return true;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
        this.rio.seek(offset);
        try {
            this.rio.write(buffer, bpos, length);
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public long length() throws IOException {
        return this.rio.length();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.rio = null;
    }
}

