/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.impl.RandomAccessFileX;
import com.imagero.uio.io.IOutils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileContent
extends Content {
    private RandomAccessFile raf;

    public RandomAccessFileContent(File f2) throws IOException {
        this(f2, RandomAccessFileContent.getMode(f2));
    }

    public RandomAccessFileContent(File f2, String mode) throws IOException {
        this(new RandomAccessFileX(f2, mode));
    }

    static String getMode(File f2) {
        if (!f2.exists() || f2.canWrite()) {
            return "rw";
        }
        return "r";
    }

    public RandomAccessFileContent(RandomAccessFile raf) {
        this.raf = raf;
    }

    public int load(long offset, int bpos, byte[] b2) throws IOException {
        long max = this.raf.length() - offset;
        int len = (int)Math.min(max, (long)(b2.length - bpos));
        if (len > 0) {
            this.raf.seek(offset);
            this.raf.readFully(b2, bpos, len);
            return len;
        }
        throw new EOFException();
    }

    public boolean canReload() {
        return true;
    }

    public void close() {
        IOutils.closeStream(this.raf);
    }

    public boolean writable() {
        return true;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
        this.raf.seek(offset);
        try {
            this.raf.write(buffer, bpos, length);
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.raf = null;
    }
}

