/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.io.IOutils;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class MemoryCachedInputStreamContent
extends Content {
    InputStream in;
    int chunkSize;
    boolean finished;
    int overflow = 5;
    Hashtable ht = new Hashtable();
    int lastChunkSize;
    long readCount;

    public MemoryCachedInputStreamContent(InputStream in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
    }

    public int load(long offset, int destOffset, byte[] dest) throws IOException {
        long index = offset / (long)this.chunkSize;
        if (this.finished && index >= this.readCount) {
            throw new EOFException();
        }
        if (!this.finished) {
            try {
                long i2 = this.readCount;
                while (i2 <= index) {
                    byte[] b2 = new byte[this.chunkSize];
                    Chunk chunk = this.addChunk(b2, i2);
                    int length = b2.length;
                    this.lastChunkSize = this.chunkSize;
                    try {
                        IOutils.readFully(this.in, b2);
                    }
                    catch (UnexpectedEOFException ex) {
                        length = (int)ex.getCount();
                    }
                    if (chunk.src.length != length) {
                        if (length > 0) {
                            b2 = new byte[length];
                            System.arraycopy(chunk.src, 0, b2, 0, length);
                            chunk.src = b2;
                            this.lastChunkSize = length;
                        } else {
                            this.ht.remove(new Long(i2));
                        }
                        this.finished = true;
                        break;
                    }
                    ++i2;
                }
            }
            catch (IOException iOException) {
                this.finished = true;
            }
        }
        if (index <= this.readCount) {
            return this.copyData(dest, destOffset, offset);
        }
        return 0;
    }

    protected void prepare() {
        try {
            long i2 = this.readCount;
            while (!this.finished) {
                byte[] b2 = new byte[this.chunkSize];
                Chunk chunk = this.addChunk(b2, i2);
                int length = b2.length;
                this.lastChunkSize = this.chunkSize;
                try {
                    IOutils.readFully(this.in, b2);
                }
                catch (UnexpectedEOFException ex) {
                    length = (int)ex.getCount();
                }
                if (chunk.src.length != length) {
                    if (length > 0) {
                        b2 = new byte[length];
                        System.arraycopy(chunk.src, 0, b2, 0, length);
                        chunk.src = b2;
                        this.lastChunkSize = length;
                    } else {
                        this.ht.remove(new Long(i2));
                    }
                    this.finished = true;
                    break;
                }
                ++i2;
            }
        }
        catch (IOException iOException) {
            this.finished = true;
        }
    }

    private int copyData(byte[] dest, int destOffset, long streamOffset) {
        long index = streamOffset / (long)this.chunkSize;
        Chunk chunk = (Chunk)this.ht.get(new Long(index));
        if (chunk != null) {
            return chunk.copyInterval(dest, destOffset, streamOffset);
        }
        return 0;
    }

    public void close() {
    }

    private Chunk addChunk(byte[] buf, long index) {
        long start = index * (long)this.chunkSize;
        Chunk helper = new Chunk(buf, index, start);
        ++this.readCount;
        this.ht.put(new Long(index), helper);
        return helper;
    }

    public boolean canReload() {
        return false;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
    }

    public long length() throws IOException {
        if (!this.finished) {
            this.prepare();
        }
        return (this.readCount - 1L) * (long)this.chunkSize + (long)this.lastChunkSize;
    }

    public boolean writable() {
        return false;
    }

    class Chunk {
        byte[] src;
        long index;
        long start;
        private Chunk parent;
        private Chunk left;
        private Chunk right;

        public Chunk(byte[] buf, long index, long start) {
            MemoryCachedInputStreamContent.this = MemoryCachedInputStreamContent.this;
            this.src = buf;
            this.index = index;
            this.start = start;
        }

        int copyInterval(byte[] dest, int destOffset, long absOffset) {
            if (this.src != null) {
                if (this.start > absOffset || absOffset > this.start + (long)this.src.length) {
                    throw new IndexOutOfBoundsException("Given offset is out of chunk bounds");
                }
                if (destOffset < 0 || destOffset > dest.length) {
                    throw new IndexOutOfBoundsException("Illegal destination offset: " + destOffset);
                }
                int srcOffset = (int)(absOffset - this.start);
                int length = Math.min(dest.length - destOffset, this.src.length - srcOffset);
                System.arraycopy(this.src, srcOffset, dest, destOffset, length);
                if (srcOffset == 0 && length == this.src.length) {
                    this.free();
                } else if (srcOffset == 0) {
                    byte[] buf = new byte[this.src.length - length];
                    System.arraycopy(this.src, length, buf, 0, buf.length);
                    this.src = buf;
                } else if (srcOffset + length == this.src.length) {
                    byte[] buf = new byte[this.src.length - length];
                    System.arraycopy(this.src, 0, buf, 0, buf.length);
                    this.src = buf;
                } else {
                    byte[] leftBuf = new byte[srcOffset];
                    System.arraycopy(this.src, 0, leftBuf, 0, leftBuf.length);
                    this.left = new Chunk(leftBuf, -1L, this.start);
                    this.left.parent = this;
                    byte[] rightBuf = new byte[this.src.length - (srcOffset + length)];
                    System.arraycopy(this.src, srcOffset + length, rightBuf, 0, rightBuf.length);
                    this.right = new Chunk(rightBuf, -1L, this.start + (long)srcOffset + (long)length);
                    this.right.parent = this;
                    this.src = null;
                }
                return length;
            }
            Chunk chunk = this.getChild(absOffset);
            if (chunk != null) {
                return chunk.copyInterval(dest, destOffset, absOffset);
            }
            return 0;
        }

        private Chunk getChild(long absOffset) {
            if (this.right.start <= absOffset) {
                if (this.right.src != null) {
                    return this.right;
                }
                return this.right.getChild(absOffset);
            }
            if (this.left.start <= absOffset) {
                if (this.left.src != null) {
                    return this.left;
                }
                return this.left.getChild(absOffset);
            }
            return null;
        }

        private void free() {
            if (this.parent != null) {
                this.parent.removeChild(this);
            } else {
                MemoryCachedInputStreamContent.this.ht.remove(new Long(this.index));
            }
        }

        private void removeChild(Chunk c2) {
            if (c2 == null && c2.parent != this) {
                return;
            }
            if (c2 == this.left) {
                this.left = null;
            } else if (c2 == this.right) {
                this.right = null;
            } else {
                return;
            }
            if (this.left == null && this.right == null) {
                this.free();
            } else if (this.left != null) {
                this.connectChild(this.left);
            } else if (this.right != null) {
                this.connectChild(this.right);
            }
        }

        private void connectChild(Chunk c2) {
            this.src = c2.src;
            this.left = c2.left;
            this.right = c2.right;
        }
    }
}

