/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.io.IOutils;
import com.imagero.uio.io.UnexpectedEOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HTTPContent
extends Content {
    URL url;
    long length;

    public HTTPContent(URL url) {
        String protocol = url.getProtocol();
        if (!"http".equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException("http protokol only");
        }
        this.url = url;
    }

    public int load(long offset, int bpos, byte[] buffer) throws IOException {
        HttpURLConnection httpcon = (HttpURLConnection)this.url.openConnection();
        httpcon.setAllowUserInteraction(true);
        httpcon.setDoInput(true);
        httpcon.setDoOutput(true);
        httpcon.setRequestMethod("GET");
        httpcon.setUseCaches(false);
        httpcon.setRequestProperty("Range", "bytes=" + offset + "-" + (offset + (long)buffer.length - (long)bpos));
        httpcon.connect();
        int responseCode = httpcon.getResponseCode();
        if (responseCode != 206) {
            httpcon.disconnect();
            throw new IOException("byteserving not supported by server");
        }
        InputStream in = httpcon.getInputStream();
        int count = 0;
        try {
            try {
                int len = buffer.length - bpos;
                IOutils.readFully(in, buffer, bpos, len);
                count = len;
            }
            catch (UnexpectedEOFException ex) {
                count = (int)ex.getCount();
            }
            Object var10_10 = null;
            httpcon.disconnect();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            httpcon.disconnect();
            throw throwable;
        }
        return count;
    }

    public void close() {
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
    }

    public long length() throws IOException {
        if (this.length == 0L) {
            HttpURLConnection httpcon = (HttpURLConnection)this.url.openConnection();
            httpcon.setRequestMethod("HEAD");
            httpcon.setUseCaches(false);
            httpcon.connect();
            this.length = httpcon.getContentLength();
            httpcon.disconnect();
        }
        return this.length;
    }

    public boolean canReload() {
        return false;
    }

    public boolean writable() {
        return false;
    }
}

