/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.Transformer;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.IndexAndStart;
import java.io.IOException;

public class FloatArrayContent
extends Content {
    float[][] data;
    boolean bigEndian;
    static final int SHIFT = 2;

    public FloatArrayContent(float[][] data) {
        this(data, true);
    }

    public FloatArrayContent(float[][] data, boolean bigEndian) {
        this.data = data;
        this.bigEndian = bigEndian;
    }

    public int load(long offset, int bpos, byte[] dest) throws IOException {
        if ((offset & 3L) != 0L || (dest.length - bpos & 3) != 0) {
            throw new IOException("Illegal offset or length");
        }
        long off = offset >> 2;
        int len = dest.length - bpos >> 2;
        IndexAndStart ias = this.getIAS(off);
        if (ias == null) {
            return 0;
        }
        int index = ias.index;
        float[] src = this.data[index];
        int pos = (int)(off - ias.start);
        int toCopy = Math.min(src.length - pos, len);
        if (toCopy > 0) {
            Transformer.floatToByte(src, pos, toCopy, dest, bpos, this.bigEndian);
            if (toCopy < len) {
                int copiedBytes = toCopy << 2;
                return toCopy + this.load(offset + (long)copiedBytes, bpos + copiedBytes, dest);
            }
        }
        return toCopy;
    }

    public void close() {
    }

    private IndexAndStart getIAS(long offset) {
        long start = 0L;
        int i2 = 0;
        while (i2 < this.data.length) {
            float[] src = this.data[i2];
            int length = src.length;
            long end = start + (long)length;
            if (offset >= start && offset <= end) {
                return new IndexAndStart(i2, start);
            }
            start += (long)length;
            ++i2;
        }
        return null;
    }

    public void save(long offset, int spos, byte[] src, int length) throws IOException {
        if ((offset & 3L) != 0L || (src.length - spos & 3) != 0) {
            throw new IOException("Illegal offset or length");
        }
        long off = offset >> 2;
        int len = Math.min(src.length - spos, length) >> 2;
        IndexAndStart ias = this.getIAS(off);
        if (ias == null) {
            return;
        }
        int index = ias.index;
        long start = ias.start;
        int dpos = (int)(off - start);
        float[] dest = this.data[index];
        int request = len;
        int toCopy = Math.min(dest.length - dpos, request);
        if (request > 0 && toCopy > 0) {
            Transformer.byteToFloat(src, spos, toCopy, dest, dpos, true);
            if (toCopy < request) {
                int copiedBytes = toCopy << 2;
                this.save(offset + (long)copiedBytes, spos + copiedBytes, src, request - toCopy << 2);
            }
        }
    }

    public boolean canReload() {
        return true;
    }

    public long length() throws IOException {
        long length = 0L;
        int i2 = 0;
        while (i2 < this.data.length) {
            float[] dest = this.data[i2];
            length += (long)dest.length;
            ++i2;
        }
        return length << 2;
    }

    public boolean writable() {
        return true;
    }
}

