/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.impl.TmpRandomAccessFile;
import com.imagero.uio.io.IOutils;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FileCachedInputStreamContent
extends Content {
    InputStream in;
    File tmp;
    TmpRandomAccessFile tmpRaf;

    public FileCachedInputStreamContent(InputStream in, File tmp) throws IOException {
        this.in = in;
        this.tmp = tmp;
        this.tmpRaf = new TmpRandomAccessFile(tmp, "rw");
    }

    public int load(long offset, int bpos, byte[] buffer) throws IOException {
        long nl;
        long length = this.tmpRaf.length();
        if (length < (nl = offset + (long)buffer.length - (long)bpos)) {
            this.tmpRaf.seek(length);
            IOutils.copy(nl - length, this.in, (DataOutput)this.tmpRaf);
        }
        this.tmpRaf.seek(offset);
        this.tmpRaf.readFully(buffer, bpos, buffer.length - bpos);
        return buffer.length - bpos;
    }

    public void save(long offset, int bpos, byte[] buffer, int length) throws IOException {
    }

    public long length() throws IOException {
        return this.tmp.length() + (long)this.in.available();
    }

    public void close() {
        IOutils.closeStream(this.tmpRaf);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        IOutils.closeStream(this.tmpRaf);
        this.tmpRaf = null;
    }

    public boolean canReload() {
        return true;
    }

    public boolean writable() {
        return false;
    }
}

